/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.test.query.dsl.MonthClassBridge;
import org.hibernate.search.test.query.dsl.RomanNumberFieldBridge;

@Entity
@Indexed
@ClassBridge(impl=MonthClassBridge.class)
public class Month {
    private Integer id;
    private int monthValue;
    @Field
    @NumericField
    public double raindropInMm;
    private String name;
    private String mythology;
    private String history;
    private Date estimatedCreation;

    public Month() {
    }

    public Month(String name, int monthValue, String mythology, String history, Date estimatedCreation) {
        this.name = name;
        this.mythology = mythology;
        this.history = history;
        this.estimatedCreation = estimatedCreation;
        this.monthValue = monthValue;
    }

    public Month(String name, int monthValue, String mythology, String history, Date estimatedCreation, double raindropInMm) {
        this(name, monthValue, mythology, history, estimatedCreation);
        this.raindropInMm = raindropInMm;
    }

    @Id
    @GeneratedValue
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Fields(value={@Field(analyze=Analyze.NO, norms=Norms.NO), @Field(analyze=Analyze.NO, norms=Norms.NO, name="monthRomanNumber", bridge=@FieldBridge(impl=RomanNumberFieldBridge.class))})
    public int getMonthValue() {
        return this.monthValue;
    }

    public void setMonthValue(int monthValue) {
        this.monthValue = monthValue;
    }

    @Field
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Fields(value={@Field, @Field(name="mythology_stem", analyzer=@Analyzer(definition="stemmer")), @Field(name="mythology_ngram", analyzer=@Analyzer(definition="ngram"))})
    public String getMythology() {
        return this.mythology;
    }

    public void setMythology(String mythology) {
        this.mythology = mythology;
    }

    @Field
    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.MINUTE)
    public Date getEstimatedCreation() {
        return this.estimatedCreation;
    }

    public void setEstimatedCreation(Date estimatedCreation) {
        this.estimatedCreation = estimatedCreation;
    }
}

