/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.test.query.dsl.Month;
import org.hibernate.search.test.query.dsl.RomanNumberFieldBridge;

public class MonthClassBridge
implements FieldBridge {
    public static final String FIELD_NAME_1 = "monthValueAsRomanNumberFromClassBridge1";
    public static final String FIELD_NAME_2 = "monthValueAsRomanNumberFromClassBridge2";

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Month month = (Month)value;
        luceneOptions.addFieldToDocument(FIELD_NAME_1, new RomanNumberFieldBridge().objectToString(month.getMonthValue()), document);
        luceneOptions.addFieldToDocument(FIELD_NAME_2, new RomanNumberFieldBridge().objectToString(month.getMonthValue()), document);
    }
}

