/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.junit.Assert;
import org.junit.Test;

public class SimpleFacetingTest
extends AbstractFacetTest {
    private final String indexFieldName = "cubicCapacity";
    private final String facetName = "ccs";

    @Test
    public void testSimpleFaceting() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertEquals((String)"Wrong number of facets", (long)4L, (long)facetList.size());
    }

    @Test
    public void testDefaultSortOrderIsCount() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4, 0});
    }

    @Test
    public void testCountSortOrderAsc() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_ASC).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{0, 4, 4, 5});
    }

    @Test
    public void testCountSortOrderDesc() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4, 0});
    }

    @Test
    public void testAlphabeticalSortOrder() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.FIELD_VALUE).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        for (int i = 1; i < facetList.size() - 1; ++i) {
            String currentFacetValue;
            String previousFacetValue = ((Facet)facetList.get(i - 1)).getValue();
            Assert.assertTrue((String)"Wrong alphabetical sort order", (previousFacetValue.compareTo(currentFacetValue = ((Facet)facetList.get(i)).getValue()) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testZeroCountsExcluded() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4});
    }

    @Test
    public void testMaxFacetCounts() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).maxFacetCount(1).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertEquals((String)"The number of facets should be restricted", (long)1L, (long)facetList.size());
        this.assertFacetCounts(facetList, new int[]{5});
    }

    @Test
    public void testNullFieldNameThrowsException() {
        try {
            this.queryBuilder(Car.class).facet().name("ccs").onField(null).discrete().createFacetingRequest();
            Assert.fail((String)"null should not be a valid field name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullRequestNameThrowsException() {
        try {
            this.queryBuilder(Car.class).facet().name(null).onField("cubicCapacity").discrete().createFacetingRequest();
            Assert.fail((String)"null should not be a valid request name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownFieldNameReturnsEmptyResults() {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("foo").onField("foobar").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertTrue((boolean)facetList.isEmpty());
    }

    @Test
    public void testRangeDefinitionSortOrderThrowsExceptionForDiscreteFaceting() {
        try {
            this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).createFacetingRequest();
            Assert.fail((String)"RANGE_DEFINITION_ODER not allowed on discrete faceting");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    @Test
    public void testEnableDisableFacets() {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        Assert.assertTrue((String)"We should have facet results", (query.getFacetManager().getFacets("ccs").size() > 0 ? 1 : 0) != 0);
        query.getFacetManager().disableFaceting("ccs");
        query.list();
        Assert.assertTrue((String)"We should have no facets", (query.getFacetManager().getFacets("ccs").size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleFacets() {
        String descendingOrderedFacet = "desc";
        FacetingRequest requestDesc = this.queryBuilder(Car.class).facet().name("desc").onField("cubicCapacity").discrete().createFacetingRequest();
        String ascendingOrderedFacet = "asc";
        FacetingRequest requestAsc = this.queryBuilder(Car.class).facet().name("asc").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_ASC).createFacetingRequest();
        TermQuery term = new TermQuery(new Term("make", "honda"));
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)term, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(requestDesc);
        facetManager.enableFaceting(requestAsc);
        this.assertFacetCounts(facetManager.getFacets("desc"), new int[]{5, 4, 4, 0});
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 4, 4, 5});
        facetManager.disableFaceting("desc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)query.getFacetManager().getFacets("desc").isEmpty());
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 4, 4, 5});
        facetManager.disableFaceting("asc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("desc").isEmpty());
        Assert.assertTrue((String)"ascendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("asc").isEmpty());
    }

    private FullTextQuery queryHondaWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)13L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }
}

