/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.shards.CustomerShardingStrategy;
import org.hibernate.search.testsupport.indexmanager.RamIndexManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomerShardingStrategyTest {
    private CustomerShardingStrategy shardStrategy;

    @Before
    public void setUp() throws Exception {
        this.shardStrategy = new CustomerShardingStrategy();
        this.shardStrategy.initialize(null, new IndexManager[]{RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory()});
    }

    @Test
    public void testGetDirectoryProvidersForQuery() {
        FullTextFilterImpl filter = new FullTextFilterImpl();
        filter.setName("customer");
        filter.setParameter("customerID", (Object)5);
        IndexManager[] providers = this.shardStrategy.getIndexManagersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[]{filter});
        Assert.assertTrue((providers.length == 1 ? 1 : 0) != 0);
        Document document = new Document();
        document.add((IndexableField)new Field("customerID", "5", Field.Store.NO, Field.Index.NOT_ANALYZED));
        Assert.assertTrue((boolean)providers[0].equals(this.shardStrategy.getIndexManagerForAddition(null, null, null, document)));
    }
}

