/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import org.hibernate.search.spatial.impl.Point;
import org.junit.Assert;
import org.junit.Test;

public class PointTest {
    @Test
    public void normalizeTest() {
        Point point = Point.fromDegrees((double)45.0, (double)517.0);
        Assert.assertEquals((double)45.0, (double)point.getLatitude(), (double)0.0);
        Assert.assertEquals((double)157.0, (double)point.getLongitude(), (double)0.0);
        Point point2 = Point.fromDegrees((double)0.0, (double)-185.0);
        Assert.assertEquals((double)175.0, (double)point2.getLongitude(), (double)0.0);
        Point point3 = Point.fromDegrees((double)110.0, (double)0.0);
        Assert.assertEquals((double)70.0, (double)point3.getLatitude(), (double)0.0);
        Point point4 = Point.fromDegrees((double)-110.0, (double)0.0);
        Assert.assertEquals((double)-70.0, (double)point4.getLatitude(), (double)0.0);
        Point point5 = Point.fromDegrees((double)185.0, (double)0.0);
        Assert.assertEquals((double)-5.0, (double)point5.getLatitude(), (double)0.0);
        Point point6 = Point.fromDegrees((double)90.0, (double)180.0);
        Assert.assertEquals((double)90.0, (double)point6.getLatitude(), (double)0.0);
        Assert.assertEquals((double)180.0, (double)point6.getLongitude(), (double)0.0);
        Point point7 = Point.fromDegrees((double)-90.0, (double)-180.0);
        Assert.assertEquals((double)-90.0, (double)point7.getLatitude(), (double)0.0);
        Assert.assertEquals((double)180.0, (double)point7.getLongitude(), (double)0.0);
    }

    @Test
    public void computeDestinationTest() {
        Point point = Point.fromDegrees((double)45.0, (double)4.0);
        Point destination = point.computeDestination(100.0, 45.0);
        Assert.assertEquals((double)0.796432523, (double)destination.getLatitudeRad(), (double)1.0E-5);
        Assert.assertEquals((double)0.08568597, (double)destination.getLongitudeRad(), (double)1.0E-5);
    }

    @Test
    public void distanceToPoint() {
        Point point = Point.fromDegrees((double)45.0, (double)4.0);
        Point point2 = Point.fromDegrees((double)46.0, (double)14.0);
        double distance = point.getDistanceTo(point2);
        Assert.assertEquals((double)786.7, (double)distance, (double)0.1);
    }
}

