/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.spatial.Position;

@Entity
@Indexed
public class Restaurant {
    @Id
    Integer id;
    @Field(store=Store.YES)
    String name;
    @IndexedEmbedded
    Position position;

    public Restaurant(Integer id, String name, String address, double latitude, double longitude) {
        this.id = id;
        this.name = name;
        this.position = new Position();
        this.position.address = address;
        this.position.latitude = latitude;
        this.position.longitude = longitude;
    }

    public Restaurant() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.position.address;
    }

    public Double getLatitude() {
        return this.position.latitude;
    }

    public Double getLongitude() {
        return this.position.longitude;
    }
}

