/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.spatial.Event;
import org.hibernate.search.test.spatial.GetterUser;
import org.hibernate.search.test.spatial.Hotel;
import org.hibernate.search.test.spatial.NonGeoPOI;
import org.hibernate.search.test.spatial.POI;
import org.hibernate.search.test.spatial.RangeEvent;
import org.hibernate.search.test.spatial.RangeHotel;
import org.hibernate.search.test.spatial.Restaurant;
import org.hibernate.search.test.spatial.User;
import org.hibernate.search.test.spatial.UserEx;
import org.hibernate.search.test.spatial.UserRange;
import org.junit.Assert;
import org.junit.Test;

public class SpatialIndexingTest
extends SearchTestBase {
    @Test
    public void testIndexing() throws Exception {
        POI poi = new POI(1, "Test", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Test2", 0.0, -179.0, "");
        POI poi3 = new POI(3, "Test3", 0.0, 179.0, "");
        POI poi4 = new POI(4, "Test4", 89.0, 1.0, "");
        POI poi5 = new POI(5, "Test5", -90.0, 17.0, "");
        POI poi6 = new POI(6, "Test6", 47.0, 154.0, "");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi);
        fullTextSession.save((Object)poi2);
        fullTextSession.save((Object)poi3);
        fullTextSession.save((Object)poi4);
        fullTextSession.save((Object)poi5);
        fullTextSession.save((Object)poi6);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{POI.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        Query luceneQuery3 = builder.spatial().onCoordinates("location").within(112.0, Unit.KM).ofLatitude(0.0).andLongitude(180.0).createQuery();
        FullTextQuery hibQuery3 = fullTextSession.createFullTextQuery(luceneQuery3, new Class[]{POI.class});
        List results3 = hibQuery3.list();
        Assert.assertEquals((long)2L, (long)results3.size());
        Query luceneQuery4 = builder.spatial().onCoordinates("location").within(100000.0, Unit.KM).ofLatitude(0.0).andLongitude(0.0).createQuery();
        FullTextQuery hibQuery4 = fullTextSession.createFullTextQuery(luceneQuery4, new Class[]{POI.class});
        List results4 = hibQuery4.list();
        Assert.assertEquals((long)6L, (long)results4.size());
        List pois = fullTextSession.createQuery("from " + POI.class.getName()).list();
        for (Object entity : pois) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testDistanceProjection() throws Exception {
        POI poi = new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        POI poi3 = new POI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        POI poi4 = new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        POI poi5 = new POI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        POI poi6 = new POI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi);
        fullTextSession.save((Object)poi2);
        fullTextSession.save((Object)poi3);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi4);
        fullTextSession.save((Object)poi5);
        fullTextSession.save((Object)poi6);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Object[] fourthResult = (Object[])results.get(3);
        Object[] fifthResult = (Object[])results.get(4);
        Object[] sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)((Double)firstResult[1]), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((Double)secondResult[1]), (double)10.1582, (double)1.0E-4);
        Assert.assertEquals((double)((Double)thirdResult[1]), (double)11.1195, (double)1.0E-4);
        Assert.assertEquals((double)((Double)fourthResult[1]), (double)15.0636, (double)1.0E-4);
        Assert.assertEquals((double)((Double)fifthResult[1]), (double)22.239, (double)0.001);
        Assert.assertEquals((double)((Double)sixthResult[1]), (double)24.446, (double)0.001);
        List pois = fullTextSession.createQuery("from " + POI.class.getName()).list();
        for (Object entity : pois) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testDistanceSort() throws Exception {
        POI poi = new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        POI poi3 = new POI(3, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        POI poi4 = new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        POI poi5 = new POI(5, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        POI poi6 = new POI(6, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi);
        fullTextSession.save((Object)poi2);
        fullTextSession.save((Object)poi3);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi4);
        fullTextSession.save((Object)poi5);
        fullTextSession.save((Object)poi6);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        List pois = fullTextSession.createQuery("from " + POI.class.getName()).list();
        for (Object entity : pois) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testNonGeoDistanceSort() throws Exception {
        NonGeoPOI poi = new NonGeoPOI(1, "Distance to 24,32 : 0", 24.0, null, "");
        NonGeoPOI poi2 = new NonGeoPOI(2, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        NonGeoPOI poi3 = new NonGeoPOI(3, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        NonGeoPOI poi4 = new NonGeoPOI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        NonGeoPOI poi5 = new NonGeoPOI(5, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        NonGeoPOI poi6 = new NonGeoPOI(6, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi);
        fullTextSession.save((Object)poi2);
        fullTextSession.save((Object)poi3);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)poi4);
        fullTextSession.save((Object)poi5);
        fullTextSession.save((Object)poi6);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(NonGeoPOI.class).get();
        Query luceneQuery = builder.all().createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{NonGeoPOI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        List pois = fullTextSession.createQuery("from " + NonGeoPOI.class.getName()).list();
        for (Object entity : pois) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationOnFieldLevel() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("d M yyyy");
        Date date = dateFormat.parse("10 9 1976");
        Event event = new Event(1, "Test", 24.0, 32.0, date);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)event);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Event.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Event.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Event.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + Event.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationWithSubAnnotationsLevel() throws Exception {
        User user = new User(1, 24.0, 32.0);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)user);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(User.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("home").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{User.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("home").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{User.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + User.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationWithSubAnnotationsLevelRangeMode() throws Exception {
        UserRange user = new UserRange(1, 24.0, 32.0);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)user);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(UserRange.class).get();
        Query luceneQuery = builder.spatial().onDefaultCoordinates().within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{UserRange.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onDefaultCoordinates().within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{UserRange.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + UserRange.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialsAnnotation() throws Exception {
        UserEx user = new UserEx(1, 24.0, 32.0, 11.9, 27.4);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)user);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(UserEx.class).get();
        Query luceneQuery = builder.spatial().onDefaultCoordinates().within(100.0, Unit.KM).ofLatitude(24.0).andLongitude(31.5).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{UserEx.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)1L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("work").within(100.0, Unit.KM).ofLatitude(12.0).andLongitude(27.5).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{UserEx.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + UserEx.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationOnFieldLevelRangeMode() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("d M yyyy");
        Date date = dateFormat.parse("10 9 1976");
        RangeEvent event = new RangeEvent(1, "Test", 24.0, 32.0, date);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)event);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(RangeEvent.class).get();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query luceneQuery = builder.spatial().onCoordinates("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{RangeEvent.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{RangeEvent.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + RangeEvent.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationOnClassLevel() throws Exception {
        Hotel hotel = new Hotel(1, "Plazza Ath\u00e9n\u00e9e", 24.0, 32.0, "Luxurious");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)hotel);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Hotel.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("hotel_location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Hotel.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("hotel_location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Hotel.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + Hotel.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationOnClassLevelRangeMode() throws Exception {
        RangeHotel hotel = new RangeHotel(1, "Plazza Ath\u00e9n\u00e9e", 24.0, 32.0, "Luxurious");
        RangeHotel hotel2 = new RangeHotel(2, "End of the world Hotel - Left", 0.0, 179.0, "Roots");
        RangeHotel hotel3 = new RangeHotel(3, "End of the world Hotel - Right", 0.0, -179.0, "Cosy");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)hotel);
        fullTextSession.save((Object)hotel2);
        fullTextSession.save((Object)hotel3);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(RangeHotel.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{RangeHotel.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{RangeHotel.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        double endOfTheWorldLatitude = 0.0;
        double endOfTheWorldLongitude = 180.0;
        Query luceneQuery3 = builder.spatial().onCoordinates("location").within(112.0, Unit.KM).ofLatitude(endOfTheWorldLatitude).andLongitude(endOfTheWorldLongitude).createQuery();
        FullTextQuery hibQuery3 = fullTextSession.createFullTextQuery(luceneQuery3, new Class[]{RangeHotel.class});
        List results3 = hibQuery3.list();
        Assert.assertEquals((long)2L, (long)results3.size());
        Query luceneQuery4 = builder.spatial().onCoordinates("location").within(100000.0, Unit.KM).ofLatitude(endOfTheWorldLatitude).andLongitude(endOfTheWorldLongitude).createQuery();
        FullTextQuery hibQuery4 = fullTextSession.createFullTextQuery(luceneQuery4, new Class[]{RangeHotel.class});
        List results4 = hibQuery4.list();
        Assert.assertEquals((long)3L, (long)results4.size());
        List events = fullTextSession.createQuery("from " + RangeHotel.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialAnnotationOnEmbeddableFieldLevel() throws Exception {
        Restaurant restaurant = new Restaurant(1, "Al's kitchen", "42, space avenue CA8596 BYOB Street", 24.0, 32.0);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)restaurant);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Restaurant.class).get();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query luceneQuery = builder.spatial().onCoordinates("position.location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Restaurant.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("position.location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Restaurant.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + Restaurant.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSpatialLatLongOnGetters() throws Exception {
        GetterUser user = new GetterUser(1, 24.0, 32.0);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)user);
        tx.commit();
        tx = fullTextSession.beginTransaction();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(GetterUser.class).get();
        Query luceneQuery = builder.spatial().onCoordinates("home").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{GetterUser.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onCoordinates("home").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{GetterUser.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List events = fullTextSession.createQuery("from " + GetterUser.class.getName()).list();
        for (Object entity : events) {
            fullTextSession.delete(entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{POI.class, Event.class, Hotel.class, User.class, UserRange.class, UserEx.class, RangeHotel.class, RangeEvent.class, Restaurant.class, NonGeoPOI.class, GetterUser.class};
    }
}

