/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchTransactionalContext;
import org.hibernate.search.batchindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.batchindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.batchindexing.impl.IdentifierProducer;
import org.hibernate.search.batchindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace
extends ErrorHandledRunnable {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor sessionFactory;
    private final ProducerConsumerQueue<List<Serializable>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<?> indexedType;
    private final String idNameOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final BatchBackend backend;
    private final long objectsLimit;
    private final int idFetchSize;

    public BatchIndexingWorkspace(SearchFactoryImplementor searchFactoryImplementor, SessionFactoryImplementor sessionFactory, Class<?> entityType, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend, long objectsLimit, int idFetchSize) {
        super(searchFactoryImplementor);
        this.indexedType = entityType;
        this.idFetchSize = idFetchSize;
        this.idNameOfIndexedType = searchFactoryImplementor.getIndexBinding(entityType).getDocumentBuilder().getIdentifierName();
        this.sessionFactory = sessionFactory;
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.backend = backend;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.documentBuilderThreads);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        try {
            ErrorHandler errorHandler = this.searchFactoryImplementor.getErrorHandler();
            BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.searchFactoryImplementor, this.sessionFactory, errorHandler);
            this.startTransformationToLuceneWork(transactionalContext, errorHandler);
            this.startProducingPrimaryKeys(transactionalContext, errorHandler);
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", (Object)this.indexedType.getName());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SearchException("Interrupted on batch Indexing; index will be left in unknown state!", (Throwable)e);
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext, ErrorHandler errorHandler) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierProducer(this.primaryKeyStream, (SessionFactory)this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit, errorHandler, this.idFetchSize));
        ThreadPoolExecutor execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        try {
            execIdentifiersLoader.execute(primaryKeyOutputter);
        }
        finally {
            execIdentifiersLoader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransformationToLuceneWork(BatchTransactionalContext transactionalContext, ErrorHandler errorHandler) {
        OptionallyWrapInJTATransaction documentOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierConsumerDocumentProducer(this.primaryKeyStream, this.monitor, (SessionFactory)this.sessionFactory, this.producerEndSignal, this.cacheMode, this.indexedType, this.searchFactoryImplementor, this.idNameOfIndexedType, this.backend, errorHandler));
        ThreadPoolExecutor execFirstLoader = Executors.newFixedThreadPool((int)this.documentBuilderThreads, (String)"entityloader");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                execFirstLoader.execute(documentOutputter);
            }
        }
        finally {
            execFirstLoader.shutdown();
        }
    }
}

