/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchTransactionalContext {
    private static final Log log = LoggerFactory.make();
    final SessionFactoryImplementor factory;
    final ErrorHandler errorHandler;
    final TransactionManager transactionManager;
    final TransactionFactory<?> transactionFactory;
    final SearchFactoryImplementor searchFactoryImplementor;

    public BatchTransactionalContext(SearchFactoryImplementor searchFactoryImplementor, SessionFactoryImplementor sessionFactory, ErrorHandler errorHandler) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.factory = sessionFactory;
        this.errorHandler = errorHandler;
        this.transactionManager = BatchTransactionalContext.lookupTransactionManager(this.factory);
        this.transactionFactory = BatchTransactionalContext.lookupTransactionFactory(this.factory);
    }

    private static TransactionFactory<?> lookupTransactionFactory(SessionFactoryImplementor sessionFactory) {
        return (TransactionFactory)sessionFactory.getServiceRegistry().getService(TransactionFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransactionManager lookupTransactionManager(SessionFactoryImplementor sessionFactory) {
        try (Session session = sessionFactory.openSession();){
            EventSource eventSource = (EventSource)session;
            TransactionManager transactionManager = eventSource.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJtaPlatform().retrieveTransactionManager();
            return transactionManager;
        }
    }

    boolean wrapInTransaction() {
        if (!this.transactionFactory.compatibleWithJtaSynchronization()) {
            log.trace((Object)"TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        if (this.transactionManager == null) {
            log.trace((Object)"No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (this.transactionManager.getStatus() == 6) {
                log.trace((Object)"No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace((Object)"Transaction in progress, no need to start a JTA transaction");
        return false;
    }
}

