/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

abstract class ErrorHandledRunnable
implements Runnable {
    private static final Log log = LoggerFactory.make();
    protected final SearchFactoryImplementor searchFactoryImplementor;

    protected ErrorHandledRunnable(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    @Override
    public final void run() {
        ErrorHandler errorHandler = this.searchFactoryImplementor.getErrorHandler();
        try {
            this.runWithErrorHandler();
        }
        catch (Exception re) {
            errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
            this.cleanUpOnError();
        }
    }

    protected abstract void runWithErrorHandler() throws Exception;

    protected void cleanUpOnError() {
    }
}

