/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchCoordinator;
import org.hibernate.search.batchindexing.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final SessionFactoryImplementor sessionFactory;
    protected Set<Class<?>> rootEntities = new HashSet();
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeAtEnd = true;
    private boolean purgeAtStart = true;
    private boolean optimizeAfterPurge = true;
    private MassIndexerProgressMonitor monitor;
    private int idFetchSize = 100;

    protected MassIndexerImpl(SearchIntegrator searchIntegrator, SessionFactoryImplementor sessionFactory, Class<?> ... entities) {
        this.searchFactoryImplementor = (SearchFactoryImplementor)searchIntegrator.unwrap(SearchFactoryImplementor.class);
        this.sessionFactory = sessionFactory;
        this.rootEntities = MassIndexerImpl.toRootEntities(this.searchFactoryImplementor, entities);
        this.monitor = this.searchFactoryImplementor.isJMXEnabled() ? new JMXRegistrar.IndexingProgressMonitor() : new SimpleIndexingProgressMonitor();
    }

    private static Set<Class<?>> toRootEntities(SearchFactoryImplementor searchFactoryImplementor, Class<?> ... selection) {
        HashSet entities = new HashSet();
        for (Class<?> entityType : selection) {
            Set targetedClasses = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
            if (targetedClasses.isEmpty()) {
                String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
                throw new IllegalArgumentException(msg);
            }
            entities.addAll(targetedClasses);
        }
        HashSet cleaned = new HashSet();
        HashSet<Class> toRemove = new HashSet<Class>();
        for (Class type : entities) {
            boolean typeIsOk = true;
            for (Class clazz : cleaned) {
                if (clazz.isAssignableFrom(type)) {
                    typeIsOk = false;
                    break;
                }
                if (!type.isAssignableFrom(clazz)) continue;
                toRemove.add(clazz);
            }
            if (!typeIsOk) continue;
            cleaned.add(type);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }

    @Override
    public MassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = Math.min(numberOfThreads, this.rootEntities.size());
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    @Deprecated
    public MassIndexer threadsForSubsequentFetching(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        return this;
    }

    @Override
    public MassIndexer progressMonitor(MassIndexerProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    @Override
    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeAtEnd = optimize;
        return this;
    }

    @Override
    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAtStart = purgeAll;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> start() {
        BatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)1, (String)"batch coordinator");
        try {
            Future<?> submit;
            Future<?> future = submit = executor.submit(coordinator);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.rootEntities, this.searchFactoryImplementor, this.sessionFactory, this.typesToIndexInParallel, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.optimizeAtEnd, this.purgeAtStart, this.optimizeAfterPurge, this.monitor, this.idFetchSize);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }

    @Override
    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }
}

