/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.util.impl.Maps;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
Serializable {
    private static final Log log = LoggerFactory.make();
    private static final String INDEXING_STRATEGY_MANUAL = "manual";
    private static final String INDEXING_STRATEGY_EVENT = "event";
    private boolean disabled;
    private boolean skipDirtyChecks = true;
    private SearchFactoryImplementor searchFactoryImplementor;
    private final transient Map<Session, Synchronization> flushSynch = Maps.createIdentityWeakKeyConcurrentMap((int)64, (int)32);

    public void onPostDelete(PostDeleteEvent event) {
        if (this.disabled) {
            return;
        }
        Object entity = event.getEntity();
        if (this.getDocumentBuilder(entity) != null) {
            boolean identifierRollbackEnabled = event.getSession().getFactory().getSettings().isIdentifierRollbackEnabled();
            this.processWork(entity, event.getId(), WorkType.DELETE, (AbstractEvent)event, identifierRollbackEnabled);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.disabled) {
            return;
        }
        Object entity = event.getEntity();
        if (this.getDocumentBuilder(entity) != null) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.ADD, (AbstractEvent)event, false);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.disabled) {
            return;
        }
        Object entity = event.getEntity();
        AbstractDocumentBuilder docBuilder = this.getDocumentBuilder(entity);
        if (docBuilder != null && (this.skipDirtyChecks || docBuilder.isDirty(this.getDirtyPropertyNames(event)))) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.UPDATE, (AbstractEvent)event, false);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
        if (this.disabled) {
            return;
        }
        EventSource session = event.getSession();
        Synchronization synchronization = this.flushSynch.get(session);
        if (synchronization != null) {
            this.flushSynch.remove(session);
            log.debug((Object)"flush event causing index update out of transaction");
            synchronization.beforeCompletion();
            synchronization.afterCompletion(3);
        }
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    public String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return null;
    }

    public void initialize(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        String indexingStrategy = searchFactoryImplementor.getIndexingStrategy();
        if (INDEXING_STRATEGY_EVENT.equals(indexingStrategy)) {
            this.disabled = searchFactoryImplementor.getIndexBindings().size() == 0;
        } else if (INDEXING_STRATEGY_MANUAL.equals(indexingStrategy)) {
            this.disabled = true;
        }
        log.debug((Object)("Hibernate Search event listeners " + (this.disabled ? "deactivated" : "activated")));
        if (!this.disabled) {
            this.skipDirtyChecks = !searchFactoryImplementor.isDirtyChecksEnabled();
            log.debug((Object)("Hibernate Search dirty checks " + (this.skipDirtyChecks ? "disabled" : "enabled")));
        }
    }

    public void addSynchronization(EventSource eventSource, Synchronization synchronization) {
        this.flushSynch.put((Session)eventSource, synchronization);
    }

    protected void processWork(Object entity, Serializable id, WorkType workType, AbstractEvent event, boolean identifierRollbackEnabled) {
        Work work = new Work(entity, id, workType, identifierRollbackEnabled);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.searchFactoryImplementor.getWorker().performWork(work, (TransactionContext)transactionContext);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        String collectionRole;
        if (this.disabled) {
            return;
        }
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        PersistentCollection persistentCollection = event.getCollection();
        if (persistentCollection != null) {
            if (!persistentCollection.wasInitialized()) {
                return;
            }
            collectionRole = persistentCollection.getRole();
        } else {
            collectionRole = null;
        }
        AbstractDocumentBuilder documentBuilder = this.getDocumentBuilder(entity);
        if (documentBuilder != null && documentBuilder.collectionChangeRequiresIndexUpdate(collectionRole)) {
            Serializable id = this.getId(entity, event);
            if (id == null) {
                log.idCannotBeExtracted(event.getAffectedOwnerEntityName());
                return;
            }
            this.processWork(entity, id, WorkType.COLLECTION, (AbstractEvent)event, false);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        is.defaultReadObject();
        Class<FullTextIndexEventListener> cl = FullTextIndexEventListener.class;
        Field f = cl.getDeclaredField("flushSynch");
        ReflectionHelper.setAccessible((AccessibleObject)f);
        ConcurrentMap flushSynch = Maps.createIdentityWeakKeyConcurrentMap((int)64, (int)32);
        f.set(this, flushSynch);
    }

    protected AbstractDocumentBuilder getDocumentBuilder(Object instance) {
        Class<?> clazz = instance.getClass();
        EntityIndexBinding entityIndexBinding = this.searchFactoryImplementor.getIndexBinding(clazz);
        if (entityIndexBinding != null) {
            return entityIndexBinding.getDocumentBuilder();
        }
        return this.searchFactoryImplementor.getDocumentBuilderContainedEntity(clazz);
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

