/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.util.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ContextHelper {
    private ContextHelper() {
    }

    public static SearchFactoryImplementor getSearchFactory(Session session) {
        return ContextHelper.getSearchFactoryBySessionImplementor((SessionImplementor)session);
    }

    public static SearchFactoryImplementor getSearchFactoryBySessionImplementor(SessionImplementor session) {
        return ContextHelper.getSearchFactoryBySFI(session.getFactory());
    }

    public static SearchFactoryImplementor getSearchFactoryBySFI(SessionFactoryImplementor sfi) {
        SearchFactoryReference factoryReference = (SearchFactoryReference)sfi.getServiceRegistry().getService(SearchFactoryReference.class);
        if (factoryReference != null) {
            return factoryReference.getSearchFactory();
        }
        throw LoggerFactory.make().searchFactoryReferenceServiceNotFound();
    }
}

