/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.FullTextSharedSessionBuilder;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.batchindexing.impl.DefaultMassIndexerFactory;
import org.hibernate.search.batchindexing.spi.MassIndexerFactory;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.impl.FullTextSharedSessionBuilderDelegator;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class FullTextSessionImpl
extends SessionDelegatorBaseImpl
implements FullTextSession,
SessionImplementor {
    private static final Log log = LoggerFactory.make();
    private transient SearchFactoryImplementor searchFactory;
    private transient SearchFactory searchFactoryAPI;
    private final TransactionContext transactionContext;

    public FullTextSessionImpl(Session session) {
        super((SessionImplementor)session, session);
        if (session == null) {
            throw log.getNullSessionPassedToFullTextSessionCreationException();
        }
        this.transactionContext = new EventSourceTransactionContext((EventSource)session);
    }

    @Override
    public FullTextQuery createFullTextQuery(Query luceneQuery, Class<?> ... entities) {
        return new FullTextQueryImpl(luceneQuery, entities, this.sessionImplementor, new ParameterMetadata(null, null));
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.purge(entityType, null);
    }

    @Override
    public void flushToIndexes() {
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        searchFactoryImplementor.getWorker().flushWorks(this.transactionContext);
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        Set targetedClasses = this.getSearchFactoryImplementor().getIndexedTypesPolymorphic(new Class[]{entityType});
        if (targetedClasses.isEmpty()) {
            String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
            throw new IllegalArgumentException(msg);
        }
        for (Class clazz : targetedClasses) {
            if (id == null) {
                this.createAndPerformWork(clazz, null, WorkType.PURGE_ALL);
                continue;
            }
            this.createAndPerformWork(clazz, id, WorkType.PURGE);
        }
    }

    private void createAndPerformWork(Class<?> clazz, Serializable id, WorkType workType) {
        Work work = new Work(clazz, id, workType);
        this.getSearchFactoryImplementor().getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        Class<T> clazz = HibernateHelper.getClass(entity);
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        if (searchFactoryImplementor.getIndexBinding(clazz) == null) {
            String msg = "Entity to index is not an @Indexed entity: " + entity.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        Serializable id = this.session.getIdentifier(entity);
        Work work = new Work(entity, id, WorkType.INDEX);
        searchFactoryImplementor.getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        MassIndexerFactory massIndexerFactory = this.createMassIndexerFactory();
        return massIndexerFactory.createMassIndexer((SearchIntegrator)this.getSearchFactoryImplementor(), this.getFactory(), types);
    }

    @Override
    public SearchFactory getSearchFactory() {
        if (this.searchFactoryAPI == null) {
            this.searchFactoryAPI = new SearchFactoryImpl((SearchIntegrator)this.getSearchFactoryImplementor());
        }
        return this.searchFactoryAPI;
    }

    private SearchFactoryImplementor getSearchFactoryImplementor() {
        if (this.searchFactory == null) {
            this.searchFactory = ContextHelper.getSearchFactory(this.session);
        }
        return this.searchFactory;
    }

    @Override
    public FullTextSharedSessionBuilder sessionWithOptions() {
        return new FullTextSharedSessionBuilderDelegator(super.sessionWithOptions());
    }

    private MassIndexerFactory createMassIndexerFactory() {
        MassIndexerFactory factory;
        Properties properties = this.getSearchFactoryImplementor().getConfigurationProperties();
        String factoryClassName = properties.getProperty("hibernate.search.massindexer.factoryclass");
        if (factoryClassName != null) {
            SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
            ServiceManager serviceManager = searchFactoryImplementor.getServiceManager();
            factory = (MassIndexerFactory)ClassLoaderHelper.instanceFromName(MassIndexerFactory.class, (String)factoryClassName, (String)"Mass indexer factory", (ServiceManager)serviceManager);
        } else {
            factory = new DefaultMassIndexerFactory();
        }
        factory.initialize(properties);
        return factory;
    }
}

