/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CriteriaObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make();
    private static final int MAX_IN_CLAUSE = 500;
    public static final CriteriaObjectInitializer INSTANCE = new CriteriaObjectInitializer();

    private CriteriaObjectInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        int maxResults = entityInfos.length;
        if (log.isTraceEnabled()) {
            log.tracef("Load %d objects using criteria queries", (Object)maxResults);
        }
        if (maxResults == 0) {
            return;
        }
        Criteria criteria = objectInitializationContext.getCriteria();
        if (criteria == null) {
            criteria = objectInitializationContext.getSession().createCriteria(objectInitializationContext.getEntityType());
        }
        this.buildUpCriteria(entityInfos, criteria, maxResults, objectInitializationContext);
        this.setCriteriaTimeout(criteria, objectInitializationContext.getTimeoutManager());
        List queryResultList = criteria.list();
        InstanceInitializer instanceInitializer = objectInitializationContext.getSearchFactoryImplementor().getInstanceInitializer();
        for (Object o : queryResultList) {
            XMember idProperty;
            Object id;
            EntityInfoLoadKey key;
            Object previousValue;
            Class loadedType = instanceInitializer.getClass(o);
            Object unproxiedObject = instanceInitializer.unproxy(o);
            DocumentBuilderIndexedEntity documentBuilder = this.getDocumentBuilder(loadedType, objectInitializationContext.getSearchFactoryImplementor());
            if (documentBuilder == null || (previousValue = idToObjectMap.put(key = new EntityInfoLoadKey(loadedType, id = ReflectionHelper.getMemberValue((Object)unproxiedObject, (XMember)(idProperty = documentBuilder.getIdGetter()))), unproxiedObject)) != null) continue;
            throw new AssertionFailure("An entity got loaded even though it was not part of the EntityInfo list");
        }
    }

    private void setCriteriaTimeout(Criteria criteria, TimeoutManager timeoutManager) {
        Long timeLeftInSecond;
        if (timeoutManager.getType() != TimeoutManager.Type.LIMIT && (timeLeftInSecond = timeoutManager.getTimeoutLeftInSeconds()) != null) {
            if (timeLeftInSecond == 0L) {
                timeoutManager.reactOnQueryTimeoutExceptionWhileExtracting(null);
            }
            criteria.setTimeout(timeLeftInSecond.intValue());
        }
    }

    private void buildUpCriteria(EntityInfo[] entityInfos, Criteria criteria, int maxResults, ObjectInitializationContext objectInitializationContext) {
        boolean exact;
        DocumentBuilderIndexedEntity documentBuilder = this.getDocumentBuilder(objectInitializationContext.getEntityType(), objectInitializationContext.getSearchFactoryImplementor());
        String idName = documentBuilder.getIdentifierName();
        Disjunction disjunction = Restrictions.disjunction();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        for (int index = 0; index < loop; ++index) {
            int max = index * 500 + 500 <= maxResults ? index * 500 + 500 : maxResults;
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            for (int entityInfoIndex = index * 500; entityInfoIndex < max; ++entityInfoIndex) {
                ids.add(entityInfos[entityInfoIndex].getId());
            }
            disjunction.add(Restrictions.in((String)idName, ids));
        }
        criteria.add((Criterion)disjunction);
    }

    private DocumentBuilderIndexedEntity getDocumentBuilder(Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor) {
        Set indexedEntities = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
        if (indexedEntities.size() > 0) {
            return searchFactoryImplementor.getIndexBinding((Class)indexedEntities.iterator().next()).getDocumentBuilder();
        }
        return null;
    }
}

