/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.AbstractLoader;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;

public class MultiClassesQueryLoader
extends AbstractLoader {
    private Session session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private List<RootEntityMetadata> entityMetadata;
    private TimeoutManager timeoutManager;
    private ObjectInitializer objectInitializer;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectInitializer objectInitializer, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
        this.objectInitializer = objectInitializer;
    }

    @Override
    public boolean isSizeSafe() {
        return true;
    }

    public void setEntityTypes(Set<Class<?>> entityTypes) {
        ArrayList<Object> safeEntityTypes = new ArrayList<Object>();
        if (entityTypes.size() == 0) {
            for (Map.Entry entry : this.searchFactoryImplementor.getIndexBindings().entrySet()) {
                if (!((EntityIndexBinding)entry.getValue()).getDocumentBuilder().isRoot()) continue;
                safeEntityTypes.add(entry.getKey());
            }
        } else {
            safeEntityTypes.addAll(entityTypes);
        }
        this.entityMetadata = new ArrayList<RootEntityMetadata>(safeEntityTypes.size());
        for (Class clazz : safeEntityTypes) {
            this.entityMetadata.add(new RootEntityMetadata(clazz, this.searchFactoryImplementor));
        }
    }

    @Override
    public Object executeLoad(EntityInfo entityInfo) {
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    @Override
    public List executeLoad(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (entityInfos.length == 1) {
            Object entity = this.load(entityInfos[0]);
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(entity);
        }
        LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap = new LinkedHashMap<EntityInfoLoadKey, Object>((int)((double)entityInfos.length / 0.75) + 1);
        HashMap<RootEntityMetadata, ArrayList<EntityInfo>> entityInfoBuckets = new HashMap<RootEntityMetadata, ArrayList<EntityInfo>>(this.entityMetadata.size());
        for (EntityInfo entityInfo : entityInfos) {
            boolean found = false;
            Class clazz = entityInfo.getClazz();
            for (RootEntityMetadata rootEntityInfo : this.entityMetadata) {
                if (rootEntityInfo.rootEntity != clazz && !rootEntityInfo.mappedSubclasses.contains(clazz)) continue;
                ArrayList<EntityInfo> bucket = (ArrayList<EntityInfo>)entityInfoBuckets.get(rootEntityInfo);
                if (bucket == null) {
                    bucket = new ArrayList<EntityInfo>();
                    entityInfoBuckets.put(rootEntityInfo, bucket);
                }
                bucket.add(entityInfo);
                found = true;
                idToObjectMap.put(new EntityInfoLoadKey(entityInfo.getClazz(), entityInfo.getId()), ObjectInitializer.ENTITY_NOT_YET_INITIALIZED);
                break;
            }
            if (found) continue;
            throw new AssertionFailure("Could not find root entity for " + clazz);
        }
        for (Map.Entry entry : entityInfoBuckets.entrySet()) {
            RootEntityMetadata key = (RootEntityMetadata)entry.getKey();
            List value = (List)entry.getValue();
            EntityInfo[] bucketEntityInfos = value.toArray(new EntityInfo[value.size()]);
            this.objectInitializer.initializeObjects(bucketEntityInfos, idToObjectMap, new ObjectInitializationContext(key.criteria, key.rootEntity, this.searchFactoryImplementor, this.timeoutManager, this.session));
            this.timeoutManager.isTimedOut();
        }
        ArrayList result = new ArrayList(idToObjectMap.size());
        for (Object o : idToObjectMap.values()) {
            if (o == ObjectInitializer.ENTITY_NOT_YET_INITIALIZED) continue;
            result.add(o);
        }
        return result;
    }

    private static class RootEntityMetadata {
        public final Class<?> rootEntity;
        public final Set<Class<?>> mappedSubclasses;
        private final Criteria criteria;

        RootEntityMetadata(Class<?> rootEntity, SearchFactoryImplementor searchFactoryImplementor) {
            this.rootEntity = rootEntity;
            EntityIndexBinding provider = searchFactoryImplementor.getIndexBinding(rootEntity);
            if (provider == null) {
                throw new AssertionFailure("Provider not found for class: " + rootEntity);
            }
            this.mappedSubclasses = provider.getDocumentBuilder().getMappedSubclasses();
            this.criteria = null;
        }
    }
}

