/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.AbstractLoader;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;

public class QueryLoader
extends AbstractLoader {
    private Session session;
    private Class entityType;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Criteria criteria;
    private boolean isExplicitCriteria;
    private TimeoutManager timeoutManager;
    private ObjectInitializer objectInitializer;
    private boolean sizeSafe = true;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectInitializer objectInitializer, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
        this.objectInitializer = objectInitializer;
    }

    @Override
    public boolean isSizeSafe() {
        return this.sizeSafe;
    }

    public void setEntityType(Class entityType) {
        this.entityType = entityType;
    }

    @Override
    public final Object executeLoad(EntityInfo entityInfo) {
        if (this.isExplicitCriteria) {
            this.load(new EntityInfo[]{entityInfo});
        }
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    @Override
    public final List executeLoad(EntityInfo ... entityInfos) {
        if (this.entityType == null) {
            throw new AssertionFailure("EntityType not defined");
        }
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap = new LinkedHashMap<EntityInfoLoadKey, Object>((int)((double)entityInfos.length / 0.75) + 1);
        for (EntityInfo entityInfo : entityInfos) {
            idToObjectMap.put(new EntityInfoLoadKey(entityInfo.getClazz(), entityInfo.getId()), ObjectInitializer.ENTITY_NOT_YET_INITIALIZED);
        }
        this.objectInitializer.initializeObjects(entityInfos, idToObjectMap, new ObjectInitializationContext(this.criteria, this.entityType, this.searchFactoryImplementor, this.timeoutManager, this.session));
        ArrayList<Object> result = new ArrayList<Object>(idToObjectMap.size());
        for (Object o : idToObjectMap.values()) {
            if (o == ObjectInitializer.ENTITY_NOT_YET_INITIALIZED) continue;
            result.add(o);
        }
        return result;
    }

    public void setCriteria(Criteria criteria) {
        if (criteria != null) {
            this.isExplicitCriteria = true;
            this.sizeSafe = true;
            if (criteria instanceof CriteriaImpl) {
                CriteriaImpl impl = (CriteriaImpl)criteria;
                this.sizeSafe = !impl.iterateExpressionEntries().hasNext() && !impl.iterateSubcriteria().hasNext();
            }
        } else {
            this.sizeSafe = true;
            this.isExplicitCriteria = false;
        }
        this.criteria = criteria;
    }
}

