/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.List;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.Department;
import org.hibernate.search.test.bridge.Departments;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class ClassBridgeTest
extends SearchTestBase {
    @Test
    public void testClassBridges() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "equipment", TestConstants.simpleAnalyzer);
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect number of results returned", (long)2L, (long)result.size());
        for (Departments d : result) {
            Assert.assertEquals((String)"incorrect manufacturer", (Object)"C", (Object)d.getManufacturer());
        }
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "branchHead", TestConstants.simpleAnalyzer);
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"incorrect entity returned", (Object)"Kent Lewin", (Object)((Departments)result.get(0)).getBranchHead());
        parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "branchnetwork", TestConstants.simpleAnalyzer);
        query = parser.parse("branchnetwork:st. george 1D");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect entity returned, wrong network", (Object)"1D", (Object)((Departments)result.get(0)).getNetwork());
        Assert.assertEquals((String)"incorrect entity returned, wrong branch", (Object)"St. George", (Object)((Departments)result.get(0)).getBranch());
        Assert.assertEquals((String)"incorrect number of results returned", (long)1L, (long)result.size());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testClassBridgesWithProjection() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "equipment", TestConstants.simpleAnalyzer);
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "__HSearch_Document"});
        ScrollableResults projections = hibQuery.scroll();
        Assert.assertNotNull((Object)projections);
        projections.beforeFirst();
        projections.next();
        Object[] projection = projections.get();
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Departments));
        Assert.assertEquals((String)"id incorrect", (long)1L, (long)((Departments)projection[0]).getId());
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[1] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)8L, (long)((Document)projection[1]).getFields().size());
        Assert.assertNotNull((String)"equiptype is null", (Object)((Document)projection[1]).getField("equiptype"));
        Assert.assertEquals((String)"equiptype incorrect", (Object)"Cisco", (Object)((Document)projection[1]).getField("equiptype").stringValue());
        Assert.assertNotNull((String)"branchnetwork is null", (Object)((Document)projection[1]).getField("branchnetwork"));
        Assert.assertEquals((String)"branchnetwork incorrect", (Object)"Salt Lake City 1A", (Object)((Document)projection[1]).getField("branchnetwork").stringValue());
        projections.next();
        projection = projections.get();
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Departments));
        Assert.assertEquals((String)"id incorrect", (long)4L, (long)((Departments)projection[0]).getId());
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[1] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)8L, (long)((Document)projection[1]).getFields().size());
        Assert.assertNotNull((String)"equiptype is null", (Object)((Document)projection[1]).getField("equiptype"));
        Assert.assertEquals((String)"equiptype incorrect", (Object)"Cisco", (Object)((Document)projection[1]).getField("equiptype").stringValue());
        Assert.assertNotNull((String)"branchnetwork is null", (Object)((Document)projection[1]).getField("branchnetwork"));
        Assert.assertEquals((String)"branchnetwork incorrect", (Object)"St. George 1D", (Object)((Document)projection[1]).getField("branchnetwork").stringValue());
        Assert.assertTrue((String)"incorrect result count returned", (boolean)projections.isLast());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testClassBridge() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDept1());
        s.persist((Object)this.getDept2());
        s.persist((Object)this.getDept3());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "branchnetwork", TestConstants.simpleAnalyzer);
        Query query = parser.parse("branchnetwork:layton 2B");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect entity returned, wrong network", (Object)"2B", (Object)((Department)result.get(0)).getNetwork());
        Assert.assertEquals((String)"incorrect entity returned, wrong branch", (Object)"Layton", (Object)((Department)result.get(0)).getBranch());
        Assert.assertEquals((String)"incorrect number of results returned", (long)1L, (long)result.size());
        query = parser.parse("branchnetwork:3c");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect entity returned, wrong network", (Object)"3C", (Object)((Department)result.get(0)).getNetwork());
        Assert.assertEquals((String)"incorrect entity returned, wrong branch", (Object)"West Valley", (Object)((Department)result.get(0)).getBranch());
        Assert.assertEquals((String)"incorrect number of results returned", (long)1L, (long)result.size());
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "branchHead", TestConstants.simpleAnalyzer);
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"incorrect entity returned", (Object)"Kent Lewin", (Object)((Department)result.get(0)).getBranchHead());
        for (Object element : s.createQuery("from " + Department.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    private Department getDept1() {
        Department dept = new Department();
        dept.setBranch("Salt Lake City");
        dept.setBranchHead("Kent Lewin");
        dept.setMaxEmployees(100);
        dept.setNetwork("1A");
        return dept;
    }

    private Department getDept2() {
        Department dept = new Department();
        dept.setBranch("Layton");
        dept.setBranchHead("Terry Poperszky");
        dept.setMaxEmployees(20);
        dept.setNetwork("2B");
        return dept;
    }

    private Department getDept3() {
        Department dept = new Department();
        dept.setBranch("West Valley");
        dept.setBranchHead("Pat Kelley");
        dept.setMaxEmployees(15);
        dept.setNetwork("3C");
        return dept;
    }

    private Departments getDepts1() {
        Departments depts = new Departments();
        depts.setBranch("Salt Lake City");
        depts.setBranchHead("Kent Lewin");
        depts.setMaxEmployees(100);
        depts.setNetwork("1A");
        depts.setManufacturer("C");
        return depts;
    }

    private Departments getDepts2() {
        Departments depts = new Departments();
        depts.setBranch("Layton");
        depts.setBranchHead("Terry Poperszky");
        depts.setMaxEmployees(20);
        depts.setNetwork("2B");
        depts.setManufacturer("3");
        return depts;
    }

    private Departments getDepts3() {
        Departments depts = new Departments();
        depts.setBranch("West Valley");
        depts.setBranchHead("Pat Kelley");
        depts.setMaxEmployees(15);
        depts.setNetwork("3C");
        depts.setManufacturer("D");
        return depts;
    }

    private Departments getDepts4() {
        Departments depts = new Departments();
        depts.setBranch("St. George");
        depts.setBranchHead("Spencer Stajskal");
        depts.setMaxEmployees(10);
        depts.setNetwork("1D");
        depts.setManufacturer("C");
        return depts;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Department.class, Departments.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

