/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.compression;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.compression.HTMLBoldFieldBridge;

@Entity
@Indexed
public class LargeDocument {
    private Long id;
    private String title;
    private String summary;
    private String text;

    LargeDocument() {
    }

    public LargeDocument(String title, String summary, String text) {
        this.summary = summary;
        this.text = text;
        this.title = title;
    }

    @Id
    @GeneratedValue
    @DocumentId
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Field(store=Store.YES)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Field(name="abstract", store=Store.COMPRESS, bridge=@FieldBridge(impl=HTMLBoldFieldBridge.class))
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Field(store=Store.COMPRESS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

