/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.File;
import java.util.Properties;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.junit.Assert;
import org.junit.Test;

public class DirectoryProviderHelperTest {
    @Test
    public void testMkdirsDetermineIndex() {
        String root = "./testDir/dir1/dir2";
        String relative = "dir3";
        Properties properties = new Properties();
        properties.put("indexBase", root);
        properties.put("indexName", relative);
        DirectoryProviderHelper.getVerifiedIndexDir((String)"name", (Properties)properties, (boolean)true);
        Assert.assertTrue((boolean)new File(root).exists());
        FileHelper.delete((File)new File("./testDir"));
    }

    @Test
    public void testMkdirsGetSource() {
        String root = "./testDir";
        String relative = "dir1/dir2/dir3";
        Properties properties = new Properties();
        properties.put("sourceBase", root);
        properties.put("source", relative);
        File rel = DirectoryProviderHelper.getSourceDirectory((String)"name", (Properties)properties, (boolean)true);
        Assert.assertTrue((boolean)rel.exists());
        FileHelper.delete((File)new File(root));
    }

    @Test
    public void testConfiguringCopyBufferSize() {
        Properties prop = new Properties();
        long mB = 0x100000L;
        Assert.assertEquals((long)0x1000000L, (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "4");
        Assert.assertEquals((long)(4L * mB), (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "1000");
        Assert.assertEquals((long)(1000L * mB), (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "0");
        boolean testOk = false;
        try {
            DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop);
        }
        catch (SearchException e) {
            testOk = true;
        }
        Assert.assertTrue((boolean)testOk);
        prop.setProperty("buffer_size_on_copy", "-100");
        testOk = false;
        try {
            DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop);
        }
        catch (SearchException e) {
            testOk = true;
        }
        Assert.assertTrue((boolean)testOk);
    }
}

