/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.fieldoncollection;

import java.util.Collection;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionItem;

public class CollectionItemFieldBridge
implements FieldBridge,
StringBridge {
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof CollectionItem)) {
            throw new IllegalArgumentException("This FieldBridge only supports CollectionItem objects.");
        }
        CollectionItem item = (CollectionItem)object;
        return item.getId().toString();
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("This FieldBridge only supports collections.");
        }
        Collection objects = (Collection)value;
        for (Object object : objects) {
            luceneOptions.addFieldToDocument(name, this.objectToString(object), document);
        }
    }
}

