/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.path.Human;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathEmbeddedDepthTest
extends SearchTestBase {
    private Session session = null;

    @Test
    public void testShouldIndexFieldInPath() throws Exception {
        List<Human> result = this.search(this.session, "parents.parents.parents.name", "Philippa");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((String)"Should be able to index a field in path regarding the depth", (Object)"John of England", (Object)result.get(0).getFullname());
    }

    @Test
    public void testIndexFieldIfInsideDepth() throws Exception {
        List<Human> result = this.search(this.session, "parents.parents.name", "Empress");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((String)"Should be able to index field inside depth and in path", (Object)"John of England", (Object)result.get(0).getFullname());
    }

    @Test
    public void testShouldNotIndexFieldOutsidePathAndOverDepth() throws Exception {
        try {
            this.search(this.session, "parents.parents.parents.surname", "de Montfort");
            Assert.fail((String)"Shoudl not index a field if not in path and over the depth threshold");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    @Test
    public void testShouldIndexFieldNotInPathButInsideDepthThreshold() throws Exception {
        List<Human> result = this.search(this.session, "parents.parents.surname", "de Ch\u00e2tellerault");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((String)"Should be able to index a field if is inside the depth threshold even if not in path", (Object)"John of England", (Object)result.get(0).getFullname());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.session = this.openSession();
        Transaction transaction = this.session.beginTransaction();
        Human[] ps = new Human[18];
        ps[1] = new Human("John", "of England");
        ps[2] = new Human("Henry II", "of England");
        ps[3] = new Human("Eleanor", "of Aquitaine");
        ps[4] = new Human("Geoffrey V", " of Anjou");
        ps[5] = new Human("Empress", "Matilda");
        ps[6] = new Human("William X", "of Aquitaine");
        ps[7] = new Human("Aenor", "de Ch\u00e2tellerault");
        ps[8] = new Human("Fulk V", "of Anjou");
        ps[9] = new Human("Ermengarde", "of Maine");
        ps[10] = new Human("Henry I", "of England");
        ps[11] = new Human("Matilda", "of Scotland");
        ps[12] = new Human("William IX", "of Aquitaine");
        ps[13] = new Human("Philippa", "of Toulouse");
        ps[14] = new Human("Aimery I", "of Ch\u00e2ttellerault");
        ps[15] = new Human("Dangereuse", "de L'Isle Bouchard");
        ps[16] = new Human("Fulk IV", "of Anjou");
        ps[17] = new Human("Bertrade", "de Montfort");
        ps[1].addParents(ps[2], ps[3]);
        ps[2].addParents(ps[4], ps[5]);
        ps[4].addParents(ps[8], ps[9]);
        ps[8].addParents(ps[16], ps[17]);
        ps[5].addParents(ps[10], ps[11]);
        ps[3].addParents(ps[6], ps[7]);
        ps[6].addParents(ps[12], ps[13]);
        ps[7].addParents(ps[14], ps[15]);
        for (int i = 1; i < 18; ++i) {
            this.session.save((Object)ps[i]);
        }
        transaction.commit();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.session.clear();
        this.deleteAll(this.session, Human.class);
        this.session.close();
        super.tearDown();
    }

    private List<Human> search(Session s, String field, String value) {
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Human.class).get();
        Query query = queryBuilder.keyword().onField(field).matching((Object)value).createQuery();
        List result = session.createFullTextQuery(query, new Class[0]).list();
        return result;
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Human.class};
    }
}

