/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.update.Grandpa;
import org.hibernate.search.test.embedded.update.Son;

@Entity
public class Dad {
    private Long id;
    private String name;
    private Grandpa grandpa;
    private Set<Son> sons = new HashSet<Son>();

    public Dad() {
    }

    public Dad(String name) {
        this.name = name;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne
    public Grandpa getGrandpa() {
        return this.grandpa;
    }

    public void setGrandpa(Grandpa grandpa) {
        this.grandpa = grandpa;
    }

    @Field(store=Store.YES)
    @Transient
    public Long getGrandpaId() {
        return this.grandpa != null ? this.grandpa.getId() : null;
    }

    @ContainedIn
    @OneToMany
    public Set<Son> getSons() {
        return this.sons;
    }

    private void setSons(Set<Son> sons) {
        this.sons = sons;
    }

    public boolean add(Son son) {
        son.setDad(this);
        return this.sons.add(son);
    }
}

