/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TransactionTest
extends SearchTestBase {
    @Test
    public void testTransactionCommit() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.persist((Object)new Document("Lucene in Action", "FullText search engine", "blah blah blah"));
        s.persist((Object)new Document("Hibernate Search in Action", "ORM and FullText search engine", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((String)"transaction.commit() should index", (long)3L, (long)this.getDocumentNumber());
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Java Persistence with Hibernate", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.flush();
        s.getTransaction().rollback();
        s.close();
        Assert.assertEquals((String)"rollback() should not index", (long)3L, (long)this.getDocumentNumber());
        s = this.getSessionFactory().openSession();
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                connection.setAutoCommit(true);
            }
        });
        s.persist((Object)new Document("Java Persistence with Hibernate", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.flush();
        s.close();
        Assert.assertEquals((String)"no transaction should index", (long)4L, (long)this.getDocumentNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNumber() throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)this.getDirectory(Document.class));){
            int n = reader.numDocs();
            return n;
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }
}

