/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.errorhandling.Foo;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.hibernate.search.test.util.progessmonitor.AssertingMassIndexerProgressMonitor;
import org.hibernate.search.testsupport.TestForIssue;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-1354")
@RunWith(value=BMUnitRunner.class)
public class ErrorHandlingDuringDocumentCreationTest
extends SearchTestBase {
    @Test
    @BMRule(targetClass="org.hibernate.search.batchindexing.impl.IdentifierConsumerDocumentProducer", targetMethod="index", action="throw new RuntimeException(\"Byteman said: Error in document creation!\")", name="testErrorInBuildingLuceneDocumentGetsCaughtByErrorHandler")
    public void testErrorInBuildingLuceneDocumentGetsCaughtByErrorHandler() throws Exception {
        MockErrorHandler mockErrorHandler = this.getErrorHandlerAndAssertCorrectTypeIsUsed();
        AssertingMassIndexerProgressMonitor progressMonitor = new AssertingMassIndexerProgressMonitor(0, 1);
        this.indexSingleFooInstance();
        this.massIndexFooInstances(progressMonitor);
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertTrue((String)("Wrong error code: " + errorMessage), (boolean)errorMessage.startsWith("HSEARCH000183"));
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof RuntimeException));
        Assert.assertEquals((Object)"Byteman said: Error in document creation!", (Object)exception.getMessage());
        progressMonitor.assertExpectedProgressMade();
    }

    private void massIndexFooInstances(MassIndexerProgressMonitor monitor) throws InterruptedException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[]{Foo.class});
        massIndexer.progressMonitor(monitor);
        massIndexer.startAndWait();
        fullTextSession.close();
    }

    private void indexSingleFooInstance() {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        session.persist((Object)new Foo());
        transaction.commit();
        session.close();
    }

    private MockErrorHandler getErrorHandlerAndAssertCorrectTypeIsUsed() {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        ErrorHandler errorHandler = integrator.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        return (MockErrorHandler)errorHandler;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

