/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.interceptor.Blog;
import org.hibernate.search.test.interceptor.BlogStatus;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1190")
public class InterceptedMassIndexerTest
extends SearchTestBase {
    @Test
    public void testMassIndexerSkips() throws InterruptedException {
        this.storeSomeBlogs();
        this.assertIndexedBooks(2);
        this.rebuildIndexes();
        this.assertIndexedBooks(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws InterruptedException {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.createIndexer(new Class[]{Blog.class}).startAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIndexedBooks(int expectedBooks) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            try {
                FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
                MatchAllDocsQuery allQuery = new MatchAllDocsQuery();
                FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)allQuery, new Class[]{Blog.class});
                int resultSize = fullTextQuery.getResultSize();
                Assert.assertEquals((long)expectedBooks, (long)resultSize);
            }
            finally {
                transaction.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSomeBlogs() {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            try {
                Blog beta1 = new Blog();
                beta1.setTitle("Hibernate Search 4.2.0.Beta1 is ready!!");
                beta1.setStatus(BlogStatus.PUBLISHED);
                session.save((Object)beta1);
                Blog lucene4 = new Blog();
                lucene4.setTitle("Apache Lucene 4 is ready. Now you can rewrite all your code from scratch!");
                lucene4.setStatus(BlogStatus.PUBLISHED);
                session.save((Object)lucene4);
                Blog beta2 = new Blog();
                beta2.setTitle("More Spatial, easy clustering, and JMX improvements");
                beta2.setStatus(BlogStatus.DRAFT);
                session.save((Object)beta2);
            }
            finally {
                transaction.commit();
            }
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Blog.class};
    }
}

