/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jmx.Counter;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1026")
public class IndexControlMBeanWithSuffixTest
extends SearchTestBase {
    MBeanServer mbeanServer;
    ObjectName indexBeanObjectName;

    @Test
    public void testIndexCtrlMBeanRegistered() throws Exception {
        Assert.assertTrue((String)"With the right property set the Search MBean should be registered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.forceConfigurationRebuild();
        super.setUp();
        String suffix = this.getCfg().getProperty("hibernate.search.jmx_bean_suffix");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.indexBeanObjectName = new ObjectName(JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)suffix));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        Assert.assertFalse((String)"The MBean should be unregistered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File targetDir = TestConstants.getTargetDir(IndexControlMBeanWithSuffixTest.class);
        File simpleJndiDir = new File(targetDir, "simpleJndi");
        simpleJndiDir.mkdir();
        cfg.setProperty("hibernate.session_factory_name", "java:comp/SessionFactory");
        cfg.setProperty("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory");
        cfg.setProperty("hibernate.jndi.org.osjava.sj.factory", "org.hibernate.search.test.jmx.IndexControlMBeanTest$CustomContextFactory");
        cfg.setProperty("hibernate.jndi.org.osjava.sj.root", simpleJndiDir.getAbsolutePath());
        cfg.setProperty("hibernate.jndi.org.osjava.sj.jndi.shared", "true");
        cfg.setProperty("hibernate.search.indexing_strategy", "manual");
        cfg.setProperty("hibernate.search.jmx_enabled", "true");
        cfg.setProperty("hibernate.search.jmx_bean_suffix", "myapp");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Counter.class};
    }
}

