/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.timeout;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.QueryTimeoutException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.timeout.Clock;
import org.hibernate.testing.SkipForDialect;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeoutTest
extends SearchTestBase {
    private FullTextSession fts;
    private Query allSeikoClocksQuery;
    private Query allSwatchClocksQuery;
    private Query noMatchQuery;
    private Query matchAllQuery;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fts = Search.getFullTextSession((Session)this.openSession());
        QueryBuilder builder = this.fts.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        this.allSeikoClocksQuery = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        this.allSwatchClocksQuery = builder.keyword().onField("brand").matching((Object)"Swatch").createQuery();
        this.noMatchQuery = builder.keyword().onField("brand").matching((Object)"Blah").createQuery();
        this.matchAllQuery = builder.all().createQuery();
        TimeoutTest.storeClocks(this.fts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() throws Exception {
        try {
            Transaction tx = this.fts.getTransaction();
            if (!tx.isActive()) {
                tx = this.fts.beginTransaction();
            }
            Assert.assertEquals((long)1000L, (long)this.fts.createQuery("delete from " + Clock.class.getName()).executeUpdate());
            this.fts.purgeAll(Clock.class);
            tx.commit();
            this.fts.close();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testTimeout() {
        Transaction tx = this.fts.beginTransaction();
        this.assertCorrectNumberOfClocksNoTimeout();
        this.assertTimeoutOccursOnList();
        this.assertTimeoutOccursOnIterate();
        this.assertTimeoutOccursOnScroll();
        tx.commit();
    }

    @Test
    public void testLimitFetchingTime() {
        Transaction tx = this.fts.beginTransaction();
        this.assertCorrectNumberOfClocksNoTimeout();
        this.assertExecutionTimeoutOccursOnList();
        this.assertExecutionTimeoutHasNoPartialResult();
        tx.commit();
    }

    @SkipForDialect(value={PostgreSQLDialect.class}, jiraKey="JBPAPP-2945", comment="PostgreSQL driver does not implement query timeout")
    @Test
    public void testEnoughTime() {
        Transaction tx = this.fts.beginTransaction();
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.matchAllQuery, new Class[]{Clock.class});
        hibernateQuery.setTimeout(5L, TimeUnit.MINUTES);
        List results = hibernateQuery.list();
        Assert.assertFalse((boolean)hibernateQuery.hasPartialResults());
        Assert.assertEquals((long)1000L, (long)results.size());
        tx.commit();
    }

    private void assertTimeoutOccursOnScroll() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.noMatchQuery, new Class[]{Clock.class});
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        try {
            hibernateQuery.scroll();
            Assert.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a QueryTimeoutException");
        }
        this.fts.clear();
    }

    private void assertTimeoutOccursOnIterate() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.allSwatchClocksQuery, new Class[]{Clock.class});
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        try {
            hibernateQuery.iterate();
            Assert.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a QueryTimeoutException");
        }
        this.fts.clear();
    }

    private void assertTimeoutOccursOnList() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.allSeikoClocksQuery, new Class[]{Clock.class});
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        try {
            hibernateQuery.list();
            Assert.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a QueryTimeoutException");
        }
        this.fts.clear();
    }

    private void assertCorrectNumberOfClocksNoTimeout() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.allSeikoClocksQuery, new Class[]{Clock.class});
        List results = hibernateQuery.list();
        Assert.assertEquals((long)500L, (long)results.size());
        this.fts.clear();
    }

    private static void storeClocks(FullTextSession fts) {
        Transaction tx = fts.beginTransaction();
        for (long i = 0L; i < 1000L; ++i) {
            Clock clock = new Clock(i, "Model cat A" + i, i % 2L == 0L ? "Seiko" : "Swatch", i + 2000L);
            fts.persist((Object)clock);
        }
        tx.commit();
        fts.clear();
    }

    private void assertExecutionTimeoutHasNoPartialResult() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.allSeikoClocksQuery, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(30L, TimeUnit.SECONDS);
        List results = hibernateQuery.list();
        Assert.assertEquals((String)"Test below limit termination", (long)500L, (long)results.size());
        Assert.assertFalse((boolean)hibernateQuery.hasPartialResults());
        this.fts.clear();
    }

    private void assertExecutionTimeoutOccursOnList() {
        FullTextQuery hibernateQuery = this.fts.createFullTextQuery(this.allSwatchClocksQuery, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(1L, TimeUnit.NANOSECONDS);
        List result = hibernateQuery.list();
        System.out.println("Result size early: " + result.size());
        Assert.assertEquals((String)"Test early failure, before the number of results are even fetched", (long)0L, (long)result.size());
        if (result.size() == 0) {
            Assert.assertTrue((boolean)hibernateQuery.hasPartialResults());
        }
        this.fts.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        cfg.setProperty("hibernate.jdbc.batch_size", "1000");
        super.configure(cfg);
    }
}

