/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class ProductsAvailabilityShardingStrategy
implements IndexShardingStrategy {
    private IndexManager availableProductsIndex;
    private IndexManager toOrderProductsIndex;
    private IndexManager[] both;

    public void initialize(Properties properties, IndexManager[] indexManagers) {
        this.availableProductsIndex = indexManagers[0];
        this.toOrderProductsIndex = indexManagers[1];
        this.both = indexManagers;
    }

    public IndexManager[] getIndexManagersForAllShards() {
        return this.both;
    }

    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        String isAvailable = document.get("available");
        if ("true".equals(isAvailable)) {
            return this.availableProductsIndex;
        }
        return this.toOrderProductsIndex;
    }

    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        return this.both;
    }

    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.both;
    }
}

