/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.event.impl.EventSourceTransactionContext;
import org.hibernate.search.event.impl.EventsIntegratorState;
import org.hibernate.search.event.impl.InitializingIntegratorState;
import org.hibernate.search.event.impl.NonInitializedIntegratorState;
import org.hibernate.search.event.impl.OptimalEventsIntegratorState;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.util.impl.Maps;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private volatile EventsIntegratorState state = new NonInitializedIntegratorState();
    private final Map<Session, Synchronization> flushSynch = Maps.createIdentityWeakKeyConcurrentMap((int)64, (int)32);

    public Map<Session, Synchronization> flushSynchForTests() {
        return this.flushSynch;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.state.eventsDisabled()) {
            return;
        }
        Object entity = event.getEntity();
        if (this.getDocumentBuilder(entity) != null) {
            boolean identifierRollbackEnabled = event.getSession().getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled();
            this.processWork(this.tenantIdentifier((AbstractEvent)event), entity, event.getId(), WorkType.DELETE, (AbstractEvent)event, identifierRollbackEnabled);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.state.eventsDisabled()) {
            return;
        }
        Object entity = event.getEntity();
        if (this.getDocumentBuilder(entity) != null) {
            Serializable id = event.getId();
            this.processWork(this.tenantIdentifier((AbstractEvent)event), entity, id, WorkType.ADD, (AbstractEvent)event, false);
        }
    }

    private String tenantIdentifier(AbstractEvent event) {
        EventSource session = event.getSession();
        return session.getTenantIdentifier();
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.state.eventsDisabled()) {
            return;
        }
        Object entity = event.getEntity();
        AbstractDocumentBuilder docBuilder = this.getDocumentBuilder(entity);
        if (docBuilder != null && (this.state.skipDirtyChecks() || docBuilder.isDirty(this.getDirtyPropertyNames(event)))) {
            Serializable id = event.getId();
            this.processWork(this.tenantIdentifier((AbstractEvent)event), entity, id, WorkType.UPDATE, (AbstractEvent)event, false);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
        if (this.state.eventsDisabled()) {
            return;
        }
        EventSource session = event.getSession();
        Synchronization synchronization = this.flushSynch.get(session);
        if (synchronization != null) {
            this.flushSynch.remove(session);
            log.debug((Object)"flush event causing index update out of transaction");
            synchronization.beforeCompletion();
            synchronization.afterCompletion(3);
        }
    }

    public ExtendedSearchIntegrator getExtendedSearchFactoryIntegrator() {
        return this.state.getExtendedSearchIntegrator();
    }

    public String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return null;
    }

    public void initialize(CompletableFuture<ExtendedSearchIntegrator> extendedIntegratorFuture) {
        this.state = new InitializingIntegratorState((CompletableFuture<ExtendedSearchIntegrator>)extendedIntegratorFuture.thenApply(this::doInitialize));
    }

    private ExtendedSearchIntegrator doInitialize(ExtendedSearchIntegrator extendedIntegrator) {
        boolean disabled = FullTextIndexEventListener.eventsDisabled(extendedIntegrator);
        boolean skipDirtyChecks = FullTextIndexEventListener.skipDirtyChecks(extendedIntegrator);
        log.debug((Object)("Hibernate Search event listeners " + (disabled ? "deactivated" : "activated")));
        if (!disabled) {
            log.debug((Object)("Hibernate Search dirty checks " + (skipDirtyChecks ? "disabled" : "enabled")));
        }
        OptimalEventsIntegratorState newState = new OptimalEventsIntegratorState(disabled, skipDirtyChecks, extendedIntegrator);
        this.state = newState;
        return extendedIntegrator;
    }

    public void addSynchronization(EventSource eventSource, Synchronization synchronization) {
        this.flushSynch.put((Session)eventSource, synchronization);
    }

    protected void processWork(String tenantIdentifier, Object entity, Serializable id, WorkType workType, AbstractEvent event, boolean identifierRollbackEnabled) {
        Work work = new Work(tenantIdentifier, entity, id, workType, identifierRollbackEnabled);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.getExtendedSearchFactoryIntegrator().getWorker().performWork(work, (TransactionContext)transactionContext);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        if (this.state.eventsDisabled()) {
            return;
        }
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        PersistentCollection persistentCollection = event.getCollection();
        String collectionRole = persistentCollection != null ? persistentCollection.getRole() : null;
        AbstractDocumentBuilder documentBuilder = this.getDocumentBuilder(entity);
        if (documentBuilder != null && documentBuilder.collectionChangeRequiresIndexUpdate(collectionRole)) {
            Serializable id = this.getId(entity, event);
            if (id == null) {
                log.idCannotBeExtracted(event.getAffectedOwnerEntityName());
                return;
            }
            this.processWork(this.tenantIdentifier((AbstractEvent)event), entity, id, WorkType.COLLECTION, (AbstractEvent)event, false);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    protected AbstractDocumentBuilder getDocumentBuilder(Object instance) {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchFactoryIntegrator();
        Class<?> clazz = instance.getClass();
        IndexedTypeIdentifier type = integrator.getIndexBindings().keyFromPojoType(clazz);
        EntityIndexBinding entityIndexBinding = integrator.getIndexBinding(type);
        if (entityIndexBinding != null) {
            return entityIndexBinding.getDocumentBuilder();
        }
        return integrator.getDocumentBuilderContainedEntity(type);
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public static boolean skipDirtyChecks(ExtendedSearchIntegrator extendedIntegrator) {
        return !extendedIntegrator.isDirtyChecksEnabled();
    }

    public static boolean eventsDisabled(ExtendedSearchIntegrator extendedIntegrator) {
        if (extendedIntegrator.getIndexingMode() == IndexingMode.EVENT) {
            return extendedIntegrator.getIndexBindings().size() == 0;
        }
        return extendedIntegrator.getIndexingMode() == IndexingMode.MANUAL;
    }
}

