/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
@Table(name="IBT_Entity")
public class IterableBridgeTestEntity {
    static final String NULL_TOKEN = "NULL_MARKER";
    static final String NULL_NUMERIC_TOKEN = "-1";
    static final String NULL_EMBEDDED = "EMBEDDED_NULL";
    static final String NULL_EMBEDDED_NUMERIC = "-1";
    private Long id;
    private String name;
    private Set<Language> nullIndexed = new HashSet<Language>();
    private List<String> nullNotIndexed = new ArrayList<String>();
    private Set<Integer> numericNullIndexed = new HashSet<Integer>();
    private List<Long> numericNullNotIndexed = new ArrayList<Long>();
    private List<Date> dates = new ArrayList<Date>();

    @Id
    @GeneratedValue
    @Column(name="iterable_id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(indexNullAs="NULL_MARKER", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(indexNullAs="EMBEDDED_NULL")
    @CollectionTable(name="NullIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="nullIndexed")
    public Set<Language> getNullIndexed() {
        return this.nullIndexed;
    }

    public void setNullIndexed(Set<Language> nullIndexed) {
        this.nullIndexed = nullIndexed;
    }

    public void addNullIndexed(Language nullIndexed) {
        this.nullIndexed.add(nullIndexed);
    }

    @Field(store=Store.YES, indexNullAs="-1", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(prefix="embeddedNum", indexNullAs="-1")
    @CollectionTable(name="NumericNullIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="numericNullIndexed")
    public Set<Integer> getNumericNullIndexed() {
        return this.numericNullIndexed;
    }

    public void setNumericNullIndexed(Set<Integer> phoneNumbers) {
        this.numericNullIndexed = phoneNumbers;
    }

    public void addNumericNullIndexed(Integer number) {
        this.numericNullIndexed.add(number);
    }

    @Field(store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @CollectionTable(name="NullNotIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="nullNotIndexed")
    public List<String> getNullNotIndexed() {
        return this.nullNotIndexed;
    }

    public void setNullNotIndexed(List<String> skipNullCollection) {
        this.nullNotIndexed = skipNullCollection;
    }

    public void addNullNotIndexed(String value) {
        this.nullNotIndexed.add(value);
    }

    @Field(store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @CollectionTable(name="NumericNullNotIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="numericNullNotIndexed")
    public List<Long> getNumericNullNotIndexed() {
        return this.numericNullNotIndexed;
    }

    public void setNumericNullNotIndexed(List<Long> numericSkipNullCollection) {
        this.numericNullNotIndexed = numericSkipNullCollection;
    }

    public void addNumericNullNotIndexed(Long value) {
        this.numericNullNotIndexed.add(value);
    }

    @Field(analyze=Analyze.NO, store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @DateBridge(resolution=Resolution.SECOND)
    @CollectionTable(name="Dates", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="dates")
    public List<Date> getDates() {
        return this.dates;
    }

    public void setDates(List<Date> dates) {
        this.dates = dates;
    }

    public void addDate(Date value) {
        this.dates.add(value);
    }

    public String toString() {
        return IterableBridgeTestEntity.class.getSimpleName() + "[id=" + this.id + ", name=" + this.name + "]";
    }

    public static enum Language {
        ITALIAN,
        ENGLISH,
        PIRATE,
        KLINGON;

    }
}

