/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CustomLockProviderTest {
    private static final String SINGLE_INSTANCE_LOCK_FQN = "org.apache.lucene.store.SingleInstanceLockFactory$SingleInstanceLock";
    private static final String SIMPLE_LOCK_FQN = "org.apache.lucene.store.SimpleFSLockFactory$SimpleFSLock";
    private static final String NATIVE_LOCK_FQN = "org.apache.lucene.store.NativeFSLockFactory$NativeFSLock";

    @Test
    public void testUseOfCustomLockingFactory() {
        Assert.assertNull((Object)CustomLockFactoryProvider.optionValue);
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider").build();
        builder.close();
        Assert.assertEquals((Object)"somethingHere", (Object)CustomLockFactoryProvider.optionValue);
        CustomLockFactoryProvider.optionValue = null;
    }

    @Test
    public void testFailOnNonExistentLockingFactory() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        try {
            builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.NotExistingFactory").build();
            builder.close();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"Unable to find locking_strategy implementation class: org.hibernate.NotExistingFactory", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testUseOfNativeLockingFactory() throws IOException {
        this.testUseOfSelectedLockingFactory(null, NATIVE_LOCK_FQN, false);
        this.testUseOfSelectedLockingFactory("native", NATIVE_LOCK_FQN, false);
    }

    @Test
    public void testUseOfSingleLockingFactory() throws IOException {
        this.testUseOfSelectedLockingFactory("single", SINGLE_INSTANCE_LOCK_FQN, false);
        this.testUseOfSelectedLockingFactory("single", SINGLE_INSTANCE_LOCK_FQN, true);
        this.testUseOfSelectedLockingFactory(null, SINGLE_INSTANCE_LOCK_FQN, true);
    }

    @Test
    public void testUseOfSimpleLockingFactory() throws IOException {
        this.testUseOfSelectedLockingFactory("simple", SIMPLE_LOCK_FQN, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUseOfSelectedLockingFactory(String optionName, String expectedLockTypeName, boolean useRamDirectory) throws IOException {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSessionBuilder fullTextSessionBuilder = builder.addAnnotatedClass(SnowStorm.class);
        if (optionName != null) {
            fullTextSessionBuilder.setProperty("hibernate.search.default.locking_strategy", optionName);
        }
        if (!useRamDirectory) {
            fullTextSessionBuilder.useFileSystemDirectoryProvider(CustomLockProviderTest.class);
        }
        FullTextSessionBuilder ftsb = fullTextSessionBuilder.build();
        try {
            SearchIntegrator integrator = (SearchIntegrator)ftsb.getSearchFactory().unwrap(SearchIntegrator.class);
            EntityIndexBinding indexBindingForEntity = integrator.getIndexBinding(SnowStorm.class);
            DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
            DirectoryProvider directoryProvider = indexManager.getDirectoryProvider();
            Directory directory = directoryProvider.getDirectory();
            try (Lock lock = directory.obtainLock("my-lock");){
                Assert.assertEquals((Object)expectedLockTypeName, (Object)lock.getClass().getName());
            }
        }
        finally {
            builder.close();
        }
        Assert.assertEquals(null, (Object)CustomLockFactoryProvider.optionValue);
    }
}

