/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.junit.Assert;
import org.junit.Test;

public class FSDirectorySelectionTest
extends SearchTestBase {
    @Test
    public void testMMapDirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("mmap");
        this.assertCorrectDirectoryType(factory, MMapDirectory.class.getName());
    }

    @Test
    public void testNIODirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("nio");
        this.assertCorrectDirectoryType(factory, NIOFSDirectory.class.getName());
    }

    @Test
    public void testSimpleDirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("simple");
        this.assertCorrectDirectoryType(factory, SimpleFSDirectory.class.getName());
    }

    @Test
    public void testInvalidDirectoryType() {
        try {
            this.createSessionFactoryUsingDirectoryType("foobar");
            Assert.fail((String)"Factory creation should fail with invalid 'hibernate.search.default.filesystem_access_type' parameter ");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    private void assertCorrectDirectoryType(SessionFactory factory, String className) {
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        SearchIntegrator integrator = (SearchIntegrator)fullTextSession.getSearchFactory().unwrap(SearchIntegrator.class);
        EntityIndexBinding snowIndexBinder = integrator.getIndexBinding(SnowStorm.class);
        IndexManager[] indexManagers = snowIndexBinder.getIndexManagers();
        Assert.assertTrue((String)"Wrong number of directory providers", (indexManagers.length == 1 ? 1 : 0) != 0);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        Directory directory = indexManager.getDirectoryProvider().getDirectory();
        Assert.assertEquals((String)"Wrong directory provider type", (Object)className, (Object)directory.getClass().getName());
        session.close();
    }

    private SessionFactory createSessionFactoryUsingDirectoryType(String directoryType) {
        Configuration config = new Configuration();
        config.addAnnotatedClass(SnowStorm.class);
        config.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().toAbsolutePath().toString());
        config.setProperty("hibernate.search.default.directory_provider", FSDirectoryProvider.class.getName());
        config.setProperty("hibernate.search.default.filesystem_access_type", directoryType);
        return config.buildSessionFactory();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }
}

