/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.Coordinate;
import org.hibernate.search.test.engine.Country;
import org.hibernate.search.test.engine.Location;
import org.hibernate.search.test.engine.PinPoint;
import org.hibernate.search.test.engine.PointOfInterest;
import org.hibernate.search.test.engine.Position;
import org.hibernate.search.test.engine.TouristAttraction;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericFieldTest
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.prepareData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.cleanData();
        Assert.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    @Test
    public void testIndexAndSearchNumericField() {
        try (Session session = this.openSession();){
            FullTextSession fts = Search.getFullTextSession((Session)session);
            Transaction tx = fts.beginTransaction();
            Assert.assertEquals((String)"Query id ", (long)3L, (long)this.numericQueryFor(fts, "overriddenFieldName", 1, 3).size());
            Assert.assertEquals((String)"Query by double range", (long)3L, (long)this.numericQueryFor(fts, "latitude", -10.0, 10.0).size());
            Assert.assertEquals((String)"Query by short range", (long)3L, (long)this.numericQueryFor(fts, "importance", (short)11, (short)13).size());
            Assert.assertEquals((String)"Query by Short range", (long)3L, (long)this.numericQueryFor(fts, "fallbackImportance", Short.valueOf("11"), Short.valueOf("13")).size());
            Assert.assertEquals((String)"Query by byte range", (long)3L, (long)this.numericQueryFor(fts, "popularity", (byte)21, (byte)23).size());
            Assert.assertEquals((String)"Query by Byte range", (long)3L, (long)this.numericQueryFor(fts, "fallbackPopularity", Byte.valueOf("21"), Byte.valueOf("23")).size());
            Assert.assertEquals((String)"Query by integer range", (long)4L, (long)this.numericQueryFor(fts, "ranking", 1, 2).size());
            Assert.assertEquals((String)"Query by long range", (long)3L, (long)this.numericQueryFor(fts, "myCounter", 1L, 3L).size());
            Assert.assertEquals((String)"Query by multi-fields", (long)2L, (long)this.numericQueryFor(fts, "strMultiple", 0.7, 0.9).size());
            Assert.assertEquals((String)"Query on custom bridge by range", (long)4L, (long)this.numericQueryFor(fts, "visibleStars", -100L, 500L).size());
            Assert.assertEquals((String)"Query by id excluding upper", (long)2L, (long)this.numericQueryFor(fts, "overriddenFieldName", 1, 3, true, false).size());
            Assert.assertEquals((String)"Query by id excluding upper and lower", (long)1L, (long)this.numericQueryFor(fts, "overriddenFieldName", 1, 3, false, false).size());
            Assert.assertEquals((String)"Range Query for indexed embedded", (long)2L, (long)this.numericQueryFor(fts, "country.idh", 0.9, 1.0).size());
            Assert.assertEquals((String)"Range Query across entities", (long)1L, (long)this.numericQueryFor(fts, "pinPoints.stars", 4, 5).size());
            Assert.assertEquals((String)"Query id exact", (long)1L, (long)this.doExactQuery(fts, "overriddenFieldName", 1).getId());
            Assert.assertEquals((String)"Query double exact", (long)2L, (long)this.doExactQuery(fts, "latitude", -10.0).getId());
            Assert.assertEquals((String)"Query short exact", (long)3L, (long)this.doExactQuery(fts, "importance", 12).getId());
            Assert.assertEquals((String)"Query byte exact", (long)3L, (long)this.doExactQuery(fts, "popularity", 22).getId());
            Assert.assertEquals((String)"Query integer exact", (long)3L, (long)this.doExactQuery(fts, "longitude", -20.0).getId());
            Assert.assertEquals((String)"Query long exact", (long)4L, (long)this.doExactQuery(fts, "myCounter", 4L).getId());
            Assert.assertEquals((String)"Query multifield exact", (long)5L, (long)this.doExactQuery(fts, "strMultiple", 0.1).getId());
            Assert.assertEquals((String)"Query on custom bridge exact", (long)3L, (long)this.doExactQuery(fts, "visibleStars", 1000L).getId());
            tx.commit();
            fts.clear();
            tx = fts.beginTransaction();
            List allLocations = fts.createCriteria(Location.class).list();
            for (Object location : allLocations) {
                fts.delete(location);
            }
            tx.commit();
            fts.clear();
            tx = fts.beginTransaction();
            Assert.assertEquals((String)"Check for deletion on Query", (long)0L, (long)this.numericQueryFor(fts, "overriddenFieldName", 1, 6).size());
            Query query = NumericFieldUtils.createNumericRangeQuery((String)"overriddenFieldName", (Object)1, (Object)6, (boolean)true, (boolean)true);
            FullTextQuery fullTextQuery = fts.createFullTextQuery(query, new Class[]{Location.class}).setProjection(new String[]{"__HSearch_Document"});
            Assert.assertEquals((String)"Check for deletion on index projection", (long)0L, (long)fullTextQuery.list().size());
            tx.commit();
        }
    }

    @TestForIssue(jiraKey="HSEARCH-1193")
    @Test
    public void testNumericFieldProjections() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            Query latitudeQuery = NumericFieldUtils.createNumericRangeQuery((String)"latitude", (Object)-20.0, (Object)-20.0, (boolean)true, (boolean)true);
            List list = fullTextSession.createFullTextQuery(latitudeQuery, new Class[]{Location.class}).setProjection(new String[]{"latitude"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Object[] firstProjection = (Object[])list.get(0);
            Assert.assertEquals((long)1L, (long)firstProjection.length);
            Assert.assertEquals((Object)-20.0, (Object)firstProjection[0]);
            List listAgain = fullTextSession.createFullTextQuery(latitudeQuery, new Class[]{Location.class}).setProjection(new String[]{"coordinatePair_x", "coordinatePair_y", "importance", "popularity"}).list();
            Assert.assertEquals((long)1L, (long)listAgain.size());
            Object[] secondProjection = (Object[])listAgain.get(0);
            Assert.assertEquals((long)4L, (long)secondProjection.length);
            Assert.assertEquals((Object)1.0, (Object)secondProjection[0]);
            Assert.assertEquals((Object)2.0, (Object)secondProjection[1]);
            Assert.assertEquals((Object)10, (Object)secondProjection[2]);
            Assert.assertEquals((Object)20, (Object)secondProjection[3]);
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testShortDocumentIdExplicitlyMappedAsNumericField() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            Query query = NumericFieldUtils.createNumericRangeQuery((String)"myId", (Object)1, (Object)1, (boolean)true, (boolean)true);
            List list = fullTextSession.createFullTextQuery(query, new Class[]{Coordinate.class}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)1L, (long)((Coordinate)list.iterator().next()).getId());
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testByteDocumentIdExplicitlyMappedAsNumericField() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            Query query = NumericFieldUtils.createNumericRangeQuery((String)"myId", (Object)1, (Object)1, (boolean)true, (boolean)true);
            List list = fullTextSession.createFullTextQuery(query, new Class[]{PointOfInterest.class}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)1L, (long)((PointOfInterest)list.iterator().next()).getId());
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testByteDocumentIdMappedAsStringFieldByDefault() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            TermRangeQuery query = TermRangeQuery.newStringRange((String)"id", (String)"1", (String)"1", (boolean)true, (boolean)true);
            List list = fullTextSession.createFullTextQuery((Query)query, new Class[]{Position.class}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)1L, (long)((Position)list.iterator().next()).getId());
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testOneOfSeveralFieldsIsNumeric() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            QueryContextBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder();
            Query query = queryBuilder.forEntity(TouristAttraction.class).get().all().createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[]{TouristAttraction.class}).setProjection(new String[]{"__HSearch_Document"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Document document = (Document)((Object[])list.iterator().next())[0];
            IndexableField scoreNumeric = document.getField("scoreNumeric");
            Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)23);
            IndexableField scoreString = document.getField("scoreString");
            Assertions.assertThat((Object)scoreString.numericValue()).isNull();
            Assertions.assertThat((String)scoreString.stringValue()).isEqualTo((Object)"23");
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testSomeOfSeveralFieldsAreNumeric() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Set fields = fullTextSession.getSearchFactory().getIndexedTypeDescriptor(TouristAttraction.class).getProperty("rating").getIndexedFields();
            Assertions.assertThat((Collection)fields).onProperty("name").containsOnly(new Object[]{"rating", "ratingNumericPrecision1", "ratingNumericPrecision2"});
            for (FieldDescriptor field : fields) {
                if ("ratingNumericPrecision1".equals(field.getName())) {
                    Assertions.assertThat((Object)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.NUMERIC);
                    Assertions.assertThat((int)((NumericFieldSettingsDescriptor)field.as(NumericFieldSettingsDescriptor.class)).precisionStep()).isEqualTo(1);
                    continue;
                }
                if ("ratingNumericPrecision2".equals(field.getName())) {
                    Assertions.assertThat((Object)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.NUMERIC);
                    Assertions.assertThat((int)((NumericFieldSettingsDescriptor)field.as(NumericFieldSettingsDescriptor.class)).precisionStep()).isEqualTo(2);
                    continue;
                }
                Assertions.assertThat((Object)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.BASIC);
            }
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testNumericMappingOfEmbeddedFields() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            QueryContextBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder();
            Query query = queryBuilder.forEntity(ScoreBoard.class).get().all().createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[]{ScoreBoard.class}).setProjection(new String[]{"__HSearch_Document"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Document document = (Document)((Object[])list.iterator().next())[0];
            IndexableField scoreNumeric = document.getField("score_id");
            Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)1);
            IndexableField beta = document.getField("score_beta");
            Assertions.assertThat((Object)beta.numericValue()).isEqualTo((Object)100);
            tx.commit();
        }
    }

    private boolean indexIsEmpty() {
        int numDocsLocation = this.countSizeForType(Location.class);
        int numDocsPinPoint = this.countSizeForType(PinPoint.class);
        return numDocsLocation == 0 && numDocsPinPoint == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            SearchFactory searchFactory = fullTextSession.getSearchFactory();
            int numDocs = -1;
            IndexReader locationIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{type});
            try {
                numDocs = locationIndexReader.numDocs();
            }
            finally {
                searchFactory.getIndexReaderAccessor().close(locationIndexReader);
            }
            int n = numDocs;
            return n;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{PinPoint.class, Location.class, Coordinate.class, PointOfInterest.class, Position.class, TouristAttraction.class, ScoreBoard.class, Score.class};
    }

    private Location doExactQuery(FullTextSession fullTextSession, String fieldName, Object value) {
        Query matchQuery = NumericFieldUtils.createExactMatchQuery((String)fieldName, (Object)value);
        return (Location)fullTextSession.createFullTextQuery(matchQuery, new Class[]{Location.class}).list().get(0);
    }

    private List<?> numericQueryFor(FullTextSession fullTextSession, String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private List<?> numericQueryFor(FullTextSession fullTextSession, String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)includeLower, (boolean)includeUpper);
        return fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private void prepareData() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            Location loc1 = new Location(1, 1L, -20.0, -40.0, 1, "Random text", 1.5, this.countryFor("England", 0.947), BigDecimal.ONE, 10, 20);
            loc1.addPinPoints(new PinPoint(1, 4, loc1), new PinPoint(2, 5, loc1));
            Location loc2 = new Location(2, 2L, -10.0, -30.0, 1, "Some text", 0.786, this.countryFor("Italy", 0.951), BigDecimal.ONE, 11, 21);
            loc2.addPinPoints(new PinPoint(3, 1, loc2), new PinPoint(4, 2, loc2));
            Location loc3 = new Location(3, 3L, 0.0, -20.0, 1, "A text", 0.86, this.countryFor("Brazil", 0.813), BigDecimal.TEN, 12, 22);
            Location loc4 = new Location(4, 4L, 10.0, 0.0, 2, "Any text", 0.99, this.countryFor("France", 0.872), BigDecimal.ONE, 13, 23);
            Location loc5 = new Location(5, 5L, 20.0, 20.0, 3, "Random text", 0.1, this.countryFor("India", 0.612), BigDecimal.ONE, 14, 24);
            fullTextSession.save((Object)loc1);
            fullTextSession.save((Object)loc2);
            fullTextSession.save((Object)loc3);
            fullTextSession.save((Object)loc4);
            fullTextSession.save((Object)loc5);
            Coordinate coordinate1 = new Coordinate(1, -20.0, 20.0);
            Coordinate coordinate2 = new Coordinate(2, -30.0, 30.0);
            fullTextSession.save((Object)coordinate1);
            fullTextSession.save((Object)coordinate2);
            PointOfInterest poi1 = new PointOfInterest(1, -20.0, 20.0);
            PointOfInterest poi2 = new PointOfInterest(2, -30.0, 30.0);
            fullTextSession.save((Object)poi1);
            fullTextSession.save((Object)poi2);
            Position position1 = new Position(1, -20.0, 20.0);
            Position position2 = new Position(2, -30.0, 30.0);
            fullTextSession.save((Object)position1);
            fullTextSession.save((Object)position2);
            TouristAttraction attraction = new TouristAttraction(1, 23, 46);
            fullTextSession.save((Object)attraction);
            Score score1 = new Score();
            score1.id = 1;
            score1.subscore = 100;
            fullTextSession.save((Object)score1);
            ScoreBoard scoreboard = new ScoreBoard();
            scoreboard.id = 1L;
            scoreboard.scores.add(score1);
            fullTextSession.save((Object)scoreboard);
            tx.commit();
        }
    }

    private Country countryFor(String name, double idh) {
        return new Country(name, idh);
    }

    private void cleanData() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            List locations = fullTextSession.createCriteria(Location.class).list();
            for (Object location : locations) {
                fullTextSession.delete(location);
            }
            List coordinates = fullTextSession.createCriteria(Coordinate.class).list();
            for (Object coordinate : coordinates) {
                fullTextSession.delete(coordinate);
            }
            List pois = fullTextSession.createCriteria(PointOfInterest.class).list();
            for (Object poi : pois) {
                fullTextSession.delete(poi);
            }
            List positions = fullTextSession.createCriteria(Position.class).list();
            for (Object position : positions) {
                fullTextSession.delete(position);
            }
            List scoreboards = fullTextSession.createCriteria(ScoreBoard.class).list();
            for (ScoreBoard scoreboard : scoreboards) {
                fullTextSession.delete((Object)scoreboard);
            }
            List scores = fullTextSession.createCriteria(Score.class).list();
            for (Score score : scores) {
                fullTextSession.delete((Object)score);
            }
            tx.commit();
        }
    }

    @Indexed
    @Entity
    static class Score {
        @Id
        @NumericField
        Integer id;
        @Field(name="beta", store=Store.YES)
        Integer subscore;

        Score() {
        }
    }

    @Indexed
    @Entity
    static class ScoreBoard {
        @Id
        Long id;
        @IndexedEmbedded(includeEmbeddedObjectId=true, prefix="score_")
        @OneToMany
        Set<Score> scores = new HashSet<Score>();

        ScoreBoard() {
        }
    }
}

