/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.Map;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.junit.Assert;
import org.junit.Test;

public class RollbackTransactionTest
extends SearchTestBase {
    @Test
    public void testTransactionBehaviour() {
        Assert.assertEquals((long)0L, (long)this.countBusLinesByFullText());
        Assert.assertEquals((long)0L, (long)this.countBusLineByDatabaseCount());
        this.createBusLines(5, true);
        Assert.assertEquals((long)0L, (long)this.countBusLinesByFullText());
        Assert.assertEquals((long)0L, (long)this.countBusLineByDatabaseCount());
        this.createBusLines(5, false);
        Assert.assertEquals((long)5L, (long)this.countBusLinesByFullText());
        Assert.assertEquals((long)5L, (long)this.countBusLineByDatabaseCount());
        this.createBusLines(7, true);
        Assert.assertEquals((long)5L, (long)this.countBusLinesByFullText());
        Assert.assertEquals((long)5L, (long)this.countBusLineByDatabaseCount());
        this.createBusLines(7, false);
        Assert.assertEquals((long)12L, (long)this.countBusLinesByFullText());
        Assert.assertEquals((long)12L, (long)this.countBusLineByDatabaseCount());
    }

    private void createBusLines(int number, boolean rollback) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        for (int i = 0; i < number; ++i) {
            BusLine line = new BusLine();
            line.setBusLineName("line " + i);
            fullTextSession.persist((Object)line);
        }
        if (rollback) {
            tx.rollback();
        } else {
            tx.commit();
        }
        fullTextSession.close();
    }

    public int countBusLinesByFullText() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery ftQuery = new MatchAllDocsQuery();
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)ftQuery, new Class[]{BusLine.class});
        int count = query.list().size();
        tx.commit();
        fullTextSession.close();
        return count;
    }

    public int countBusLineByDatabaseCount() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        int count = fullTextSession.createCriteria(BusLine.class).list().size();
        tx.commit();
        fullTextSession.close();
        return count;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.directory_provider", "ram");
        cfg.put("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

