/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.indexapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.indexapi.Author;
import org.hibernate.search.test.engine.indexapi.Book;
import org.hibernate.search.test.engine.indexapi.Clock;
import org.hibernate.search.test.engine.indexapi.Leaf;
import org.hibernate.search.test.engine.indexapi.Tree;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PurgeTest
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.indexTestData();
    }

    @Test
    public void testPurgeById() throws Exception {
        this.assertNumberOfIndexedEntitiesForTypes(2, Clock.class);
        this.assertNumberOfIndexedEntitiesForTypes(2, Book.class);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        Clock clock = this.getSingleInstanceOfType(fullTextSession, Clock.class);
        fullTextSession.purge(Clock.class, (Serializable)clock.getId());
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(1, Clock.class);
        this.assertNumberOfIndexedEntitiesForTypes(2, Book.class);
    }

    @Test
    public void testPurgeAll() throws Exception {
        this.assertNumberOfIndexedEntitiesForTypes(2, Clock.class);
        this.assertNumberOfIndexedEntitiesForTypes(2, Book.class);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.purgeAll(Clock.class);
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(0, Clock.class);
        this.assertNumberOfIndexedEntitiesForTypes(2, Book.class);
        fullTextSession = Search.getFullTextSession((Session)this.openSession());
        tx = fullTextSession.beginTransaction();
        fullTextSession.purgeAll(Book.class);
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(0, Clock.class);
        this.assertNumberOfIndexedEntitiesForTypes(0, Book.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1271")
    public void testPurgeEntityWithContainedIn() throws Exception {
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(4, Leaf.class);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        Leaf leave = this.getSingleInstanceOfType(fullTextSession, Leaf.class);
        fullTextSession.purge(Leaf.class, (Serializable)Integer.valueOf(leave.getId()));
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(3, Leaf.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1271")
    public void testPurgeAllWithContainedIn() throws Exception {
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(4, Leaf.class);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.purgeAll(Leaf.class);
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(0, Leaf.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1271")
    public void testPurgeWithNullAsIdDeletesAllIndexedDocuments() throws Exception {
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(4, Leaf.class);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.purge(Leaf.class, null);
        tx.commit();
        fullTextSession.close();
        this.assertNumberOfIndexedEntitiesForTypes(1, Tree.class);
        this.assertNumberOfIndexedEntitiesForTypes(0, Leaf.class);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Clock.class, Author.class, Leaf.class, Tree.class};
    }

    private <T> T getSingleInstanceOfType(FullTextSession fullTextSession, Class<T> type) {
        Criteria criteria = fullTextSession.createCriteria(type);
        criteria.setMaxResults(1);
        return (T)criteria.list().get(0);
    }

    private void assertNumberOfIndexedEntitiesForTypes(int expectedCount, Class<?> ... types) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), (Class[])types);
            List results = query.list();
            Assert.assertEquals((String)("Incorrect document count for type: " + Arrays.toString(types)), (long)expectedCount, (long)results.size());
            tx.commit();
        }
    }

    private void indexTestData() {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction tx = fullTextSession.beginTransaction();
            Clock clock = new Clock(1, "Seiko");
            fullTextSession.save((Object)clock);
            clock = new Clock(2, "Festina");
            fullTextSession.save((Object)clock);
            Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
            fullTextSession.save((Object)book);
            book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
            fullTextSession.save((Object)book);
            Tree tree = new Tree("birch");
            for (int i = 0; i < 4; ++i) {
                tree.growNewLeave();
            }
            fullTextSession.save((Object)tree);
            tx.commit();
        }
    }
}

