/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl.embedded;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.embedded.ContainerEntity;
import org.hibernate.search.test.query.dsl.embedded.EmbeddedEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DslEmbeddedSearchTest
extends SearchTestBase {
    private Session s = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EmbeddedEntity ee = new EmbeddedEntity();
        ee.setEmbeddedField("embedded");
        ee.setNumber(7);
        ContainerEntity pe = new ContainerEntity();
        pe.setEmbeddedEntity(ee);
        pe.setParentStringValue("theparentvalue");
        this.s = this.openSession();
        this.s.getTransaction().begin();
        this.s.persist((Object)pe);
        this.s.getTransaction().commit();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.s.clear();
        this.deleteAll(this.s, ContainerEntity.class);
        this.s.close();
        super.tearDown();
    }

    @Test
    public void testSearchString() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.embeddedField").matching((Object)"embedded").createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        Assert.assertEquals((String)"DSL didn't find the embedded string field", (long)1L, (long)results.size());
        Assert.assertEquals((Object)"embedded", (Object)results.get(0).getEmbeddedEntity().getEmbeddedField());
    }

    @Test
    public void testSearchNumberWithFieldBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.num").matching((Object)7).createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        Assert.assertEquals((String)"DSL didn't find the embedded numeric field", (long)1L, (long)results.size());
        Assert.assertEquals((Object)7, (Object)results.get(0).getEmbeddedEntity().getNumber());
    }

    private List<ContainerEntity> execute(FullTextSession fullTextSession, Query q) {
        FullTextQuery combinedQuery = fullTextSession.createFullTextQuery(q, new Class[]{ContainerEntity.class});
        return combinedQuery.list();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ContainerEntity.class};
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }
}

