/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.session.DelegationWrapper;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;
import org.junit.Assert;
import org.junit.Test;

public class SessionTest
extends SearchTestBase {
    private static final Class<?>[] SESS_PROXY_INTERFACES = new Class[]{Session.class, LobCreationContext.class, EventSource.class, SessionImplementor.class, SharedSessionContract.class};

    @Test
    public void testSessionWrapper() throws Exception {
        Session s = this.openSession();
        DelegationWrapper wrapper = new DelegationWrapper(s);
        Session wrapped = (Session)Proxy.newProxyInstance(Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)wrapper);
        try {
            Search.getFullTextSession((Session)wrapped);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        wrapped.close();
    }

    @Test
    public void testDetachedCriteria() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        DetachedCriteria dc = DetachedCriteria.forClass(Email.class);
        try {
            Criteria c = dc.getExecutableCriteria((Session)s).setMaxResults(10);
            c.list();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        s.close();
    }

    @Test
    public void testThreadBoundSessionWrappingOutOfTransaction() throws Exception {
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        }
        finally {
            ThreadLocalSessionContext.unbind((SessionFactory)this.getSessionFactory());
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.connection.autocommit", "true");
        cfg.put("hibernate.current_session_context_class", "thread");
    }
}

