/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.shards.Product;
import org.hibernate.search.test.shards.ProductsAvailabilityShardingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DirectorySelectionTest
extends SearchTestBase {
    private IndexReaderAccessor indexReaderAccessor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FullTextSession fts = this.indexData();
        this.indexReaderAccessor = fts.getSearchFactory().getIndexReaderAccessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryProviderForQuery() throws Exception {
        IndexReader indexReader = this.indexReaderAccessor.open(new Class[]{Product.class});
        try {
            Assert.assertEquals((long)2L, (long)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
        indexReader = this.indexReaderAccessor.open(new String[]{"Products.0"});
        try {
            Assert.assertEquals((long)1L, (long)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
        indexReader = this.indexReaderAccessor.open(new String[]{"Products.1"});
        try {
            Assert.assertEquals((long)1L, (long)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
    }

    @Test
    public void testOpeningIndexReaderByUnknownNameThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[]{"Products.1", "hoa?"});
            Assert.fail((String)"should have failed");
        }
        catch (SearchException se) {
            Assert.assertEquals((Object)"HSEARCH000107: Index names hoa? is not defined", (Object)se.getMessage());
        }
    }

    @Test
    public void testOpeningIndexReaderUsingEmptyStringArrayThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[0]);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing", (Object)e.getMessage());
        }
    }

    @Test
    public void testOpeningIndexReaderUsingNullAsNameThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[]{null});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing", (Object)e.getMessage());
        }
    }

    @Test
    public void testOpeningIndexReaderByUnknownEntityThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[]{this.getClass()});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"HSEARCH000109: org.hibernate.search.test.shards.DirectorySelectionTest is not an indexed type", (Object)e.getMessage());
        }
    }

    @Test
    public void testOpeningIndexReaderUsingEmptyClassArrayThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[0]);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"HSEARCH000112: At least one entity type must be provided: can't open an IndexReader on nothing", (Object)e.getMessage());
        }
    }

    @Test
    public void testOpeningIndexReaderUsingNullAsClassThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[]{null});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"HSEARCH000110: 'null' is not a valid indexed type", (Object)e.getMessage());
        }
    }

    private FullTextSession indexData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Product p1 = new Product();
        p1.setName("The Definitive ANTLR Reference: Building Domain-Specific Languages");
        p1.setAvailable(true);
        s.persist((Object)p1);
        Product p2 = new Product();
        p2.setName("Recipes for distributed cloud applications using Infinispan");
        p2.setAvailable(false);
        s.persist((Object)p2);
        tx.commit();
        s.clear();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        fts.close();
        return fts;
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.Products.sharding_strategy", ProductsAvailabilityShardingStrategy.class.getCanonicalName());
        cfg.put("hibernate.search.Products.sharding_strategy.nbr_of_shards", "2");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Product.class};
    }
}

