/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.search.test.util.JdbcConnectionAccessImpl;
import org.hibernate.service.Service;
import org.hibernate.testing.env.ConnectionProviderBuilder;
import org.hibernate.tool.schema.internal.TargetDatabaseImpl;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.Target;

public class MultitenancyTestHelper {
    private final Set<String> tenantIds;
    private final boolean multitenancyEnabled;
    private AbstractMultiTenantConnectionProvider multiTenantConnectionProvider;
    private Map<String, DriverManagerConnectionProviderImpl> tenantSpecificConnectionProviders = new HashMap<String, DriverManagerConnectionProviderImpl>();

    public MultitenancyTestHelper(Set<String> tenantIds) {
        this.tenantIds = tenantIds;
        this.multitenancyEnabled = tenantIds != null && tenantIds.size() != 0;
    }

    public void enableIfNeeded(StandardServiceRegistryBuilder registryBuilder) {
        registryBuilder.addService(MultiTenantConnectionProvider.class, (Service)this.multiTenantConnectionProvider);
    }

    public void start() {
        if (this.multitenancyEnabled) {
            this.multiTenantConnectionProvider = this.buildMultiTenantConnectionProvider();
        }
    }

    private AbstractMultiTenantConnectionProvider buildMultiTenantConnectionProvider() {
        for (String tenantId : this.tenantIds) {
            DriverManagerConnectionProviderImpl connectionProvider = ConnectionProviderBuilder.buildConnectionProvider((String)tenantId);
            this.tenantSpecificConnectionProviders.put(tenantId, connectionProvider);
        }
        return new AbstractMultiTenantConnectionProvider(){

            protected ConnectionProvider getAnyConnectionProvider() {
                return (ConnectionProvider)MultitenancyTestHelper.this.tenantSpecificConnectionProviders.entrySet().iterator().next().getValue();
            }

            protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
                DriverManagerConnectionProviderImpl connectionProviderImpl = (DriverManagerConnectionProviderImpl)MultitenancyTestHelper.this.tenantSpecificConnectionProviders.get(tenantIdentifier);
                if (connectionProviderImpl == null) {
                    throw new HibernateException("Unknown tenant identifier");
                }
                return connectionProviderImpl;
            }
        };
    }

    public void close() {
        for (DriverManagerConnectionProviderImpl connectionProvider : this.tenantSpecificConnectionProviders.values()) {
            connectionProvider.stop();
        }
    }

    public void exportSchema(StandardServiceRegistry serviceRegistry, Metadata metadata, Map<String, Object> settings) {
        TargetDatabaseImpl[] targets = this.createDatabaseTargets();
        ((SchemaManagementTool)serviceRegistry.getService(SchemaManagementTool.class)).getSchemaDropper(settings).doDrop(metadata, true, (Target[])targets);
        ((SchemaManagementTool)serviceRegistry.getService(SchemaManagementTool.class)).getSchemaCreator(settings).doCreation(metadata, true, (Target[])targets);
    }

    private TargetDatabaseImpl[] createDatabaseTargets() {
        int tenantsNumber = this.tenantIds.size();
        TargetDatabaseImpl[] targets = new TargetDatabaseImpl[tenantsNumber];
        Iterator<String> iterator = this.tenantIds.iterator();
        for (int i = 0; i < tenantsNumber; ++i) {
            targets[i] = this.createDatabaseTarget(iterator.next());
        }
        return targets;
    }

    private TargetDatabaseImpl createDatabaseTarget(String tenantId) {
        DriverManagerConnectionProviderImpl connectionProviderImpl = this.tenantSpecificConnectionProviders.get(tenantId);
        return new TargetDatabaseImpl((JdbcConnectionAccess)new JdbcConnectionAccessImpl((ConnectionProvider)connectionProviderImpl));
    }

    public void forceConfigurationSettings(Map<String, Object> settings) {
        if (this.multitenancyEnabled) {
            settings.remove("hibernate.hbm2ddl.auto");
            settings.put("hibernate.multiTenancy", MultiTenancyStrategy.DATABASE.name());
        }
    }
}

