/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Map;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;

public class PaddedIntegerBridge
implements TwoWayStringBridge,
ParameterizedBridge {
    public static final String PADDING_PROPERTY = "padding";
    private int padding = 5;

    public void setParameterValues(Map<String, String> parameters) {
        String padding = parameters.get(PADDING_PROPERTY);
        if (padding != null) {
            this.padding = Integer.parseInt(padding);
        }
    }

    public String objectToString(Object object) {
        String rawInteger = object.toString();
        if (rawInteger.length() > this.padding) {
            throw new IllegalArgumentException("Try to pad on a number too big");
        }
        StringBuilder paddedInteger = new StringBuilder();
        for (int padIndex = rawInteger.length(); padIndex < this.padding; ++padIndex) {
            paddedInteger.append('0');
        }
        return paddedInteger.append(rawInteger).toString();
    }

    public Object stringToObject(String stringValue) {
        return new Integer(stringValue);
    }
}

