/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.configuration.User;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ResourceNotFoundMessageTest {
    @Test
    public void testIllegalAnalyzerDefinition() {
        try {
            new FullTextSessionBuilder().addAnnotatedClass(User.class).setProperty("hibernate.search.model_mapping", ResourceNotFoundMessageTest.class.getName()).build();
            Assert.fail((String)"should not reach this");
        }
        catch (SearchException initException) {
            String message = initException.getMessage();
            Assert.assertEquals((Object)"HSEARCH000114: Could not load resource: 'non-existent-resourcename.file'", (Object)message);
        }
    }

    @Factory
    public SearchMapping build() {
        SearchMapping mapping = new SearchMapping();
        mapping.analyzerDef("ngram", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).param("words", "non-existent-resourcename.file");
        return mapping;
    }
}

