/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.depth;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
@Indexed
public class SocialPerson {
    public Long id;
    public String name;
    public Set<SocialPerson> friends = new HashSet<SocialPerson>();
    public Set<SocialPerson> friendsReverse = new HashSet<SocialPerson>();

    public SocialPerson() {
    }

    public SocialPerson(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public void addFriends(SocialPerson ... persons) {
        for (SocialPerson p : persons) {
            this.friends.add(p);
            p.friendsReverse.add(this);
        }
    }

    @Id
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Field(analyze=Analyze.NO)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @IndexedEmbedded(includePaths={"name"})
    @ManyToMany
    public Set<SocialPerson> getFriends() {
        return this.friends;
    }

    public void setFriends(Set<SocialPerson> friends) {
        this.friends = friends;
    }

    @ManyToMany(mappedBy="friends")
    @ContainedIn
    public Set<SocialPerson> getFriendsReverse() {
        return this.friendsReverse;
    }

    public void setFriendsReverse(Set<SocialPerson> friendsReverse) {
        this.friendsReverse = friendsReverse;
    }
}

