/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path.prefixed;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.path.prefixed.EntityA;
import org.hibernate.search.test.embedded.path.prefixed.EntityB;
import org.hibernate.search.test.embedded.path.prefixed.EntityC;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrefixedEmbeddedCaseInPathTest
extends SearchTestBase {
    private Session s = null;
    private EntityA entityA = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EntityC indexedC = new EntityC("indexed");
        EntityC skippedC = new EntityC("indexed");
        EntityB indexedB = new EntityB(indexedC, skippedC);
        this.entityA = new EntityA(indexedB);
        this.s = this.openSession();
        this.persistEntity(this.s, indexedC, skippedC, indexedB, this.entityA);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.s.clear();
        this.deleteAll(this.s, EntityA.class, EntityB.class, EntityC.class);
        this.s.close();
        super.tearDown();
    }

    @Test
    public void testFieldIsIndexedIfInPath() throws Exception {
        List<EntityA> result = this.search(this.s, "prefixed_idx_field", "indexed");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)this.entityA.id, (long)result.get((int)0).id);
    }

    @Test
    public void testFieldNotIndexedIfNotInPath() throws Exception {
        try {
            this.search(this.s, "prefixed_idx_skipped", "skipped");
            Assert.fail((String)"Should not index embedded property if not in path and not in depth limit");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    @Test
    public void testEmbeddedNotIndexedIfNotInPath() throws Exception {
        try {
            this.search(this.s, "prefixed_skp_field", "indexed");
            Assert.fail((String)"Should not index embedded property if not in path and not in depth limit");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    @Test
    public void testEmbeddedNotIndexedIfNotInPath2() throws Exception {
        try {
            this.search(this.s, "prefixed_skp_skipped", "skipped");
            Assert.fail((String)"Should not index embedded property if not in path and not in depth limit");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    private List<EntityA> search(Session s, String field, String value) {
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(EntityA.class).get();
        Query query = queryBuilder.keyword().onField(field).matching((Object)value).createQuery();
        List result = session.createFullTextQuery(query, new Class[0]).list();
        return result;
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }

    private void persistEntity(Session s, Object ... entities) {
        Transaction tx = s.beginTransaction();
        for (Object entity : entities) {
            s.persist(entity);
        }
        tx.commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{EntityA.class, EntityB.class, EntityC.class};
    }
}

