/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.event.update;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.event.update.CheeseRollingCompetitor;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1999")
public class DirtyCheckingTest
extends SearchTestBase {
    @Test
    public void testName() throws Exception {
        try (FullTextSession s = Search.getFullTextSession((Session)this.openSession());){
            Transaction tx = s.beginTransaction();
            CheeseRollingCompetitor cheeser = new CheeseRollingCompetitor();
            cheeser.id = 1;
            cheeser.nickname = "Jimmy Fontina";
            s.persist((Object)cheeser);
            tx.commit();
            s.clear();
            this.assertExists(s, "Jimmy", "Jimmy Fontina");
            tx = s.beginTransaction();
            CheeseRollingCompetitor johnny = (CheeseRollingCompetitor)s.get(CheeseRollingCompetitor.class, (Serializable)Integer.valueOf(1));
            johnny.nickname = "Johnny Fontina";
            tx.commit();
            s.clear();
            this.assertExists(s, "Johnny", "Johnny Fontina");
            tx = s.beginTransaction();
            s.delete((Object)johnny);
            tx.commit();
        }
    }

    private void assertExists(FullTextSession s, String keyword, String expectedProjection) {
        QueryBuilder queryBuilder = s.getSearchFactory().buildQueryBuilder().forEntity(CheeseRollingCompetitor.class).get();
        Query q = queryBuilder.keyword().onField("Nickname").matching((Object)keyword).createQuery();
        FullTextQuery fullTextQuery = s.createFullTextQuery(q, new Class[]{CheeseRollingCompetitor.class}).setProjection(new String[]{"Nickname"});
        List list = fullTextQuery.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)expectedProjection, (Object)((Object[])list.get(0))[0]);
        s.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{CheeseRollingCompetitor.class};
    }
}

