/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jmx.Counter;
import org.hibernate.search.test.jmx.SimpleJNDIHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1026")
public class IndexControlMBeanWithSuffixTest
extends SearchTestBase {
    private static final String JNDI_APP_SUFFIX = "myapp";
    MBeanServer mbeanServer;
    ObjectName indexBeanObjectName;

    @Test
    public void testIndexCtrlMBeanRegistered() throws Exception {
        Assert.assertTrue((String)"With the right property set the Search MBean should be registered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.indexBeanObjectName = new ObjectName(JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)JNDI_APP_SUFFIX));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        Assert.assertFalse((String)"The MBean should be unregistered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        Path jndiStorage = SimpleJNDIHelper.makeTestingJndiDirectory(IndexControlMBeanWithSuffixTest.class);
        SimpleJNDIHelper.enableSimpleJndi(cfg, (Path)jndiStorage);
        cfg.put("hibernate.session_factory_name", "java:comp/SessionFactory");
        cfg.put("hibernate.jndi.org.osjava.sj.factory", "org.hibernate.search.test.jmx.IndexControlMBeanTest$CustomContextFactory");
        cfg.put("hibernate.search.indexing_strategy", "manual");
        cfg.put("hibernate.search.jmx_enabled", "true");
        cfg.put("hibernate.search.jmx_bean_suffix", JNDI_APP_SUFFIX);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Counter.class};
    }
}

