/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.EntityManager;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.serialization.SerializationTestHelper;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-117")
public class EntityManagerSerializationTest
extends JPATestCase {
    @Test
    public void testSerialization() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        EntityManagerSerializationTest.indexSearchAssert(em);
        FullTextEntityManager clone = (FullTextEntityManager)SerializationTestHelper.duplicateBySerialization((Object)em);
        EntityManagerSerializationTest.indexSearchAssert(clone);
        clone.close();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }

    private static void indexSearchAssert(FullTextEntityManager em) throws Exception {
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23, 34);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryParser parser = new QueryParser("title", TestConstants.stopAnalyzer);
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        Assert.assertEquals((long)0L, (long)em.createFullTextQuery((Query)query, new Class[0]).getResultList().size());
        query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)23, (Integer)23, (boolean)true, (boolean)true);
        Assert.assertEquals((String)"getResultList", (long)1L, (long)em.createFullTextQuery((Query)query, new Class[0]).getResultList().size());
        Assert.assertEquals((String)"getSingleResult and object retrieval", (long)23L, (long)((Bretzel)em.createFullTextQuery((Query)query, new Class[0]).getSingleResult()).getSaltQty());
        Assert.assertEquals((long)1L, (long)em.createFullTextQuery((Query)query, new Class[0]).getResultSize());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
    }
}

