/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.query.facet.Ingredient;

@Entity
@Indexed
public class Recipe {
    @Id
    @GeneratedValue
    private int id;
    @Field
    private String name;
    @ManyToMany
    @IndexedEmbedded
    private Set<Ingredient> ingredients = new HashSet<Ingredient>();

    public Recipe() {
    }

    public Recipe(String name) {
        this.name = name;
    }

    public void addIngredients(Ingredient ... ingredients) {
        Collections.addAll(this.ingredients, ingredients);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Recipe{id=" + this.id + ", name='" + this.name + '\'' + ", ingredients=" + this.ingredients + '}';
    }
}

