/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import java.util.Map;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.indexes.impl.SharingBufferReaderProvider;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.reader.Detective;
import org.hibernate.search.test.reader.Suspect;
import org.junit.Assert;
import org.junit.Test;

public class FilterOnDirectoryTest
extends SearchTestBase {
    @Test
    public void testFilteredClasses() throws Exception {
        this.createDoeFamily();
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fts.beginTransaction();
        TermQuery q = new TermQuery(new Term("name", "doe"));
        Assert.assertEquals((long)2L, (long)fts.createFullTextQuery((Query)q, new Class[0]).getResultSize());
        Assert.assertEquals((long)2L, (long)fts.createFullTextQuery((Query)q, new Class[]{Detective.class, Suspect.class}).getResultSize());
        FullTextQuery detectiveQuery = fts.createFullTextQuery((Query)q, new Class[]{Detective.class});
        Assert.assertEquals((long)1L, (long)detectiveQuery.getResultSize());
        Assert.assertTrue((boolean)(detectiveQuery.list().get(0) instanceof Detective));
        FullTextQuery suspectQuery = fts.createFullTextQuery((Query)q, new Class[]{Suspect.class});
        Assert.assertEquals((long)1L, (long)suspectQuery.getResultSize());
        Assert.assertTrue((boolean)(suspectQuery.list().get(0) instanceof Suspect));
        Assert.assertEquals((long)2L, (long)fts.createFullTextQuery((Query)q, new Class[0]).getResultSize());
        Assert.assertEquals((long)2L, (long)fts.createFullTextQuery((Query)q, new Class[]{Detective.class, Suspect.class}).getResultSize());
        tx.commit();
        fts.close();
    }

    private void createDoeFamily() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Detective detective = new Detective();
        detective.setName("John Doe");
        s.persist((Object)detective);
        Suspect suspect = new Suspect();
        suspect.setName("Jane Doe");
        s.persist((Object)suspect);
        tx.commit();
        s.close();
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.analyzer", StandardAnalyzer.class.getName());
        cfg.put("hibernate.search.default.reader.strategy", SharingBufferReaderProvider.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Detective.class, Suspect.class};
    }
}

