/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;

@Entity
@Indexed
@Spatial(name="hotel_location", spatialMode=SpatialMode.HASH)
public class Hotel
implements Coordinates {
    @Id
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    String type;
    double latitude;
    double longitude;

    public Hotel(Integer id, String name, double latitude, double longitude, String type) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.type = type;
    }

    public Hotel() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getType() {
        return this.type;
    }
}

